/* $Id: filestore_output.h 711 2006-05-29 17:49:41Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef FILESTORE_OUTPUT_H
#define FILESTORE_OUTPUT_H

#include "filestore_stats.h"
#include "statio.h"

typedef struct filestore_out *filestore_out_t;

typedef struct
{
  iostat_t          *fop_iostats;
  out_stream_t      fop_out_stream;
  off_t             fop_chunk_size;
  /* Volume label or NULL for none. */
  char              *fop_label;           
  /* passphrase filename for encryption, or NULL to disable (default: NULL) */
  char              *fop_gpg_passphrase;  
  /* true to allow gzip compression (default: true) */
  bool              fop_gzip;     
  /* true to allow bzip2 compression (default: true) */
  bool              fop_bzip2;    
  /* true to allow SHA1 checksums (default: true) */
  bool              fop_sha1sum;  
  /* true to allow MD5 checksums (default: true) */
  bool              fop_md5sum;  
  /* true to place archive label and into archive after filters are enabled.
   * If encryption is enabled, this will hide these field from users without
   * the passphrase (default: true). */
  bool              fop_info_after_filters;
  /* true to place id into archives after filters (default: false). */
  bool              fop_id_after_filters;
  bool              fop_ignore_header_error;
} filestore_out_params_t;

void init_filestore_out_params(filestore_out_params_t *params, out_stream_t out_stream);

filestore_out_t open_filestore_out (filestore_out_params_t *params);
bool close_filestore_out (filestore_out_t);
void release_filestore_out (filestore_out_t);

bool filestore_output_path (filestore_out_t, filestore_stats_t *, path_t path,
                            bool recurse,
                            void (*file_callback) (void *, path_t),
                            void *callback_data);

bool filestore_output_file (filestore_out_t, path_t path, filestore_stats_t *);

#endif
