/* $Id: darray.h 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/


/*
 * Darrays look like ordinary C arrays, and can be subscripted at such with [].
 * However, they can also be queried for their size, easily resized etc.
 */

#ifndef DARRAY_H
#define DARRAY_H

#include <stdlib.h>

void *create_darray (size_t elem_size, size_t elem_total, size_t elem_used);
void release_darray (void *);

/* Add to the end of the array.  The first argument is the array, the second
 * argument a pointer to the data to add.  May return a new pointer, if the
 * array needs to be reallocated. */
void *darray_add (void *, void *);

size_t darray_size (void *data);
void *darray_set_size (void *, size_t);
void *darray_adjust_size (void *, ssize_t);

#endif
