/* $Id: commandprocess.h 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


/**
 * This module provides easy access to external commands.
 */

#ifndef COMMANDPROCESS_H
#define COMMANDPROCESS_H

#include <stdbool.h>
#include <limits.h>

typedef char *const *args_t;
typedef struct comproc *comproc_t;

comproc_t create_comproc (void (*consumer) (void *, const char *, size_t),
                          void *,
                          const size_t bufsize,
                          const char *filename,
                          char *const argv[],
                          char *const envp[],
                          bool (*arg_cons) (void *, args_t, args_t),
                          void *arg_cons_data);

bool send_to_comproc (comproc_t cp, const char *buf, size_t len);
void finish_comproc_input (comproc_t cp);
bool restart_comproc (comproc_t cp);
void release_comproc (comproc_t cp);

// Temporary hack - this undefined with -std=c99 ??
#ifndef PIPE_BUF
#warning Why is PIPE_BUF undefined?
#define PIPE_BUF 4096
#endif

#define DEFAULT_COMPROC_BUFFER PIPE_BUF

#endif
