/* $Id: commandfilterio.h 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef COMMANDFILTERIO_H
#define COMMANDFILTERIO_H

#include "nonstdio.h"
#include "commandprocess.h"

/**
 * Create an output stream which filters all data through the given command,
 * before writing it to base_outs.  If own_base is true, the returned
 * out_stream is considered to be the owner of the base_stream, and will deal
 * with releasing it.
 */
out_stream_t commandfilter_open_out (const char *cmd,
                                     size_t bufsize,
                                     char *const argv[],
                                     char *const envp[],
                                     bool (*arg_cons) (void *, args_t argv,
                                                       args_t envp),
                                     void *arg_cons_data,
                                     out_stream_t base_outs, bool own_base);

in_stream_t commandfilter_open_in (const char *cmd,
                                   size_t bufsize,
                                   char *const argv[],
                                   char *const envp[],
                                   bool (*arg_cons) (void *, args_t argv,
                                                     args_t envp),
                                   void *arg_cons_data, in_stream_t base_ins,
                                   bool own_base);

#endif
