/*
  File autogenerated by gengetopt version 2.10
  generated with the following command:
  gengetopt --unamed-opts --input teebu.ggo 

  The developers of gengetopt consider the fixed text that goes in all
  gengetopt output files to be in the public domain:
  we make no copyright claims on it.
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* If we use autoconf.  */
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "getopt.h"

#include "cmdline.h"

void
cmdline_parser_print_version (void)
{
  printf ("%s %s\n", CMDLINE_PARSER_PACKAGE, CMDLINE_PARSER_VERSION);
}

void
cmdline_parser_print_help (void)
{
  cmdline_parser_print_version ();
  printf("\n"
  "Purpose:\n"
  "  tool for creating and restoring archives of files, with support for compression and encryption.\n"
  "\n"
  "Usage: %s [OPTIONS]... [FILES]...\n", CMDLINE_PARSER_PACKAGE);
  printf("   -h         --help                   Print help and exit\n");
  printf("   -V         --version                Print version and exit\n");
  printf("   -fSTRING   --file=STRING            filename of the archive\n");
  printf("   -lSTRING   --label=STRING           set archive label\n");
  printf("   -oSTRING   --target=STRING          set the target directory for extraction and verification (default='.')\n");
  printf("   -i         --input-filelist         read file list from stdin (default=off)\n");
  printf("   -CLONG     --chunk=LONG             chunk data into the given size (default='33554432')\n");
  printf("   -BINT      --tape-blocks=INT        write data in blocks of the given size\n");
  printf("   -GSTRING   --gpg=STRING             encrypt using gpg with the specified key file\n");
  printf("   -P         --show-progress          display progress statistics (implies --show-final) (default=off)\n");
  printf("   -F         --show-final             display final statistics (default=off)\n");
  printf("   -m         --md5                    write or verify MD5 checksums (default=off)\n");
  printf("   -s         --sha1                   write or verify SHA1 checksums (default=off)\n");
  printf("              --ignore-header          ignore archive header (you will need to supply compression and encryption) (default=off)\n");
  printf("   -eSTRING   --simulate-error=STRING  simulate an error on input (for testing)\n");
  printf("              --hide-info              if encryption is enabled, encrypt the archive label and timestamp as well (default=off)\n");
  printf("              --hide-id                if encryption is enabled, encrypt the archive uid as well (default=off)\n");
  printf("\n");
  printf("   Group: output\n");
  printf("              --silent                 least output\n");
  printf("   -q         --quiet                  less output\n");
  printf("   -v         --verbose                more output\n");
  printf("              --debug                  most output\n");
  printf("\n");
  printf("   Group: compression\n");
  printf("   -z         --gzip                   compress using gzip\n");
  printf("   -j         --bzip2                  compress using bzip2\n");
  printf("              --compress=STRING        compress using given program\n");
  printf("\n");
  printf("   Group: action\n");
  printf("   -c         --create                 create an archive\n");
  printf("   -t         --test                   test an archive\n");
  printf("   -T         --verify                 verify an archive\n");
  printf("   -x         --extract                extract an archive to the given directory\n");
  printf("   -d         --identify               display archive uid, label and timestamp\n");
  printf("   -S         --selftest               perform self test\n");
}


static char *gengetopt_strdup (const char *s);

/* gengetopt_strdup() */
/* strdup.c replacement of strdup, which is not standard */
char *
gengetopt_strdup (const char *s)
{
  char *result = (char*)malloc(strlen(s) + 1);
  if (result == (char*)0)
    return (char*)0;
  strcpy(result, s);
  return result;
}

int
cmdline_parser (int argc, char * const *argv, struct gengetopt_args_info *args_info)
{
  int c;	/* Character of the parsed option.  */
  int i;        /* Counter */
  struct simulate_error_list
  {
    char * simulate_error_arg;
    struct simulate_error_list * next;
  };
  struct simulate_error_list * simulate_error_list = NULL,* simulate_error_new = NULL;
  
  int missing_required_options = 0;
  int action_group_counter = 0;
  
  int compression_group_counter = 0;
  
  int output_group_counter = 0;
  

  args_info->help_given = 0 ;
  args_info->version_given = 0 ;
  args_info->file_given = 0 ;
  args_info->label_given = 0 ;
  args_info->target_given = 0 ;
  args_info->input_filelist_given = 0 ;
  args_info->chunk_given = 0 ;
  args_info->tape_blocks_given = 0 ;
  args_info->gpg_given = 0 ;
  args_info->show_progress_given = 0 ;
  args_info->show_final_given = 0 ;
  args_info->md5_given = 0 ;
  args_info->sha1_given = 0 ;
  args_info->ignore_header_given = 0 ;
  args_info->simulate_error_given = 0 ;
  args_info->hide_info_given = 0 ;
  args_info->hide_id_given = 0 ;
  args_info->silent_given = 0 ;
  args_info->quiet_given = 0 ;
  args_info->verbose_given = 0 ;
  args_info->debug_given = 0 ;
  args_info->gzip_given = 0 ;
  args_info->bzip2_given = 0 ;
  args_info->compress_given = 0 ;
  args_info->create_given = 0 ;
  args_info->test_given = 0 ;
  args_info->verify_given = 0 ;
  args_info->extract_given = 0 ;
  args_info->identify_given = 0 ;
  args_info->selftest_given = 0 ;
#define clear_args() { \
  args_info->file_arg = NULL; \
  args_info->label_arg = NULL; \
  args_info->target_arg = gengetopt_strdup(".") ;\
  args_info->input_filelist_flag = 0;\
  args_info->chunk_arg = 33554432 ;\
  args_info->gpg_arg = NULL; \
  args_info->show_progress_flag = 0;\
  args_info->show_final_flag = 0;\
  args_info->md5_flag = 0;\
  args_info->sha1_flag = 0;\
  args_info->ignore_header_flag = 0;\
  args_info->simulate_error_arg = NULL; \
  args_info->hide_info_flag = 0;\
  args_info->hide_id_flag = 0;\
  args_info->compress_arg = NULL; \
}

  clear_args();

  args_info->inputs = NULL;
  args_info->inputs_num = 0;

  optarg = 0;
  optind = 1;
  opterr = 1;
  optopt = '?';

  while (1)
    {
      int option_index = 0;
      char *stop_char;

      static struct option long_options[] = {
        { "help",	0, NULL, 'h' },
        { "version",	0, NULL, 'V' },
        { "file",	1, NULL, 'f' },
        { "label",	1, NULL, 'l' },
        { "target",	1, NULL, 'o' },
        { "input-filelist",	0, NULL, 'i' },
        { "chunk",	1, NULL, 'C' },
        { "tape-blocks",	1, NULL, 'B' },
        { "gpg",	1, NULL, 'G' },
        { "show-progress",	0, NULL, 'P' },
        { "show-final",	0, NULL, 'F' },
        { "md5",	0, NULL, 'm' },
        { "sha1",	0, NULL, 's' },
        { "ignore-header",	0, NULL, 0 },
        { "simulate-error",	1, NULL, 'e' },
        { "hide-info",	0, NULL, 0 },
        { "hide-id",	0, NULL, 0 },
        { "silent",	0, NULL, 0 },
        { "quiet",	0, NULL, 'q' },
        { "verbose",	0, NULL, 'v' },
        { "debug",	0, NULL, 0 },
        { "gzip",	0, NULL, 'z' },
        { "bzip2",	0, NULL, 'j' },
        { "compress",	1, NULL, 0 },
        { "create",	0, NULL, 'c' },
        { "test",	0, NULL, 't' },
        { "verify",	0, NULL, 'T' },
        { "extract",	0, NULL, 'x' },
        { "identify",	0, NULL, 'd' },
        { "selftest",	0, NULL, 'S' },
        { NULL,	0, NULL, 0 }
      };

      stop_char = 0;
      c = getopt_long (argc, argv, "hVf:l:o:iC:B:G:PFmse:qvzjctTxdS", long_options, &option_index);

      if (c == -1) break;	/* Exit from `while (1)' loop.  */

      switch (c)
        {
        case 'h':	/* Print help and exit.  */
          clear_args ();
          cmdline_parser_print_help ();
          exit (EXIT_SUCCESS);

        case 'V':	/* Print version and exit.  */
          clear_args ();
          cmdline_parser_print_version ();
          exit (EXIT_SUCCESS);

        case 'f':	/* filename of the archive.  */
          if (args_info->file_given)
            {
              fprintf (stderr, "%s: `--file' (`-f') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->file_given = 1;
          args_info->file_arg = gengetopt_strdup (optarg);
          break;

        case 'l':	/* set archive label.  */
          if (args_info->label_given)
            {
              fprintf (stderr, "%s: `--label' (`-l') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->label_given = 1;
          args_info->label_arg = gengetopt_strdup (optarg);
          break;

        case 'o':	/* set the target directory for extraction and verification.  */
          if (args_info->target_given)
            {
              fprintf (stderr, "%s: `--target' (`-o') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->target_given = 1;
          args_info->target_arg = gengetopt_strdup (optarg);
          break;

        case 'i':	/* read file list from stdin.  */
          if (args_info->input_filelist_given)
            {
              fprintf (stderr, "%s: `--input-filelist' (`-i') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->input_filelist_given = 1;
          args_info->input_filelist_flag = !(args_info->input_filelist_flag);
          break;

        case 'C':	/* chunk data into the given size.  */
          if (args_info->chunk_given)
            {
              fprintf (stderr, "%s: `--chunk' (`-C') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->chunk_given = 1;
          args_info->chunk_arg = strtol (optarg,&stop_char,0);
          break;

        case 'B':	/* write data in blocks of the given size.  */
          if (args_info->tape_blocks_given)
            {
              fprintf (stderr, "%s: `--tape-blocks' (`-B') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->tape_blocks_given = 1;
          args_info->tape_blocks_arg = strtol (optarg,&stop_char,0);
          break;

        case 'G':	/* encrypt using gpg with the specified key file.  */
          if (args_info->gpg_given)
            {
              fprintf (stderr, "%s: `--gpg' (`-G') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->gpg_given = 1;
          args_info->gpg_arg = gengetopt_strdup (optarg);
          break;

        case 'P':	/* display progress statistics (implies --show-final).  */
          if (args_info->show_progress_given)
            {
              fprintf (stderr, "%s: `--show-progress' (`-P') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->show_progress_given = 1;
          args_info->show_progress_flag = !(args_info->show_progress_flag);
          break;

        case 'F':	/* display final statistics.  */
          if (args_info->show_final_given)
            {
              fprintf (stderr, "%s: `--show-final' (`-F') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->show_final_given = 1;
          args_info->show_final_flag = !(args_info->show_final_flag);
          break;

        case 'm':	/* write or verify MD5 checksums.  */
          if (args_info->md5_given)
            {
              fprintf (stderr, "%s: `--md5' (`-m') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->md5_given = 1;
          args_info->md5_flag = !(args_info->md5_flag);
          break;

        case 's':	/* write or verify SHA1 checksums.  */
          if (args_info->sha1_given)
            {
              fprintf (stderr, "%s: `--sha1' (`-s') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->sha1_given = 1;
          args_info->sha1_flag = !(args_info->sha1_flag);
          break;

        case 'e':	/* simulate an error on input (for testing).  */
          args_info->simulate_error_given++;
          simulate_error_new = (struct simulate_error_list *) malloc (sizeof (struct simulate_error_list));
          simulate_error_new->next = simulate_error_list;
          simulate_error_list = simulate_error_new;
        
            
          simulate_error_new->simulate_error_arg = gengetopt_strdup (optarg);
          break;

        case 'q':	/* less output.  */
          if (args_info->quiet_given)
            {
              fprintf (stderr, "%s: `--quiet' (`-q') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->quiet_given = 1;
          output_group_counter += 1;
        break;

        case 'v':	/* more output.  */
          if (args_info->verbose_given)
            {
              fprintf (stderr, "%s: `--verbose' (`-v') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->verbose_given = 1;
          output_group_counter += 1;
        break;

        case 'z':	/* compress using gzip.  */
          if (args_info->gzip_given)
            {
              fprintf (stderr, "%s: `--gzip' (`-z') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->gzip_given = 1;
          compression_group_counter += 1;
        break;

        case 'j':	/* compress using bzip2.  */
          if (args_info->bzip2_given)
            {
              fprintf (stderr, "%s: `--bzip2' (`-j') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->bzip2_given = 1;
          compression_group_counter += 1;
        break;

        case 'c':	/* create an archive.  */
          if (args_info->create_given)
            {
              fprintf (stderr, "%s: `--create' (`-c') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->create_given = 1;
          action_group_counter += 1;
        break;

        case 't':	/* test an archive.  */
          if (args_info->test_given)
            {
              fprintf (stderr, "%s: `--test' (`-t') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->test_given = 1;
          action_group_counter += 1;
        break;

        case 'T':	/* verify an archive.  */
          if (args_info->verify_given)
            {
              fprintf (stderr, "%s: `--verify' (`-T') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->verify_given = 1;
          action_group_counter += 1;
        break;

        case 'x':	/* extract an archive to the given directory.  */
          if (args_info->extract_given)
            {
              fprintf (stderr, "%s: `--extract' (`-x') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->extract_given = 1;
          action_group_counter += 1;
        break;

        case 'd':	/* display archive uid, label and timestamp.  */
          if (args_info->identify_given)
            {
              fprintf (stderr, "%s: `--identify' (`-d') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->identify_given = 1;
          action_group_counter += 1;
        break;

        case 'S':	/* perform self test.  */
          if (args_info->selftest_given)
            {
              fprintf (stderr, "%s: `--selftest' (`-S') option given more than once\n", CMDLINE_PARSER_PACKAGE);
              clear_args ();
              exit (EXIT_FAILURE);
            }
          args_info->selftest_given = 1;
          action_group_counter += 1;
        break;


        case 0:	/* Long option with no short option */
          /* ignore archive header (you will need to supply compression and encryption).  */
          if (strcmp (long_options[option_index].name, "ignore-header") == 0)
          {
            if (args_info->ignore_header_given)
              {
                fprintf (stderr, "%s: `--ignore-header' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->ignore_header_given = 1;
            args_info->ignore_header_flag = !(args_info->ignore_header_flag);
            break;
          }
          
          /* if encryption is enabled, encrypt the archive label and timestamp as well.  */
          else if (strcmp (long_options[option_index].name, "hide-info") == 0)
          {
            if (args_info->hide_info_given)
              {
                fprintf (stderr, "%s: `--hide-info' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->hide_info_given = 1;
            args_info->hide_info_flag = !(args_info->hide_info_flag);
            break;
          }
          
          /* if encryption is enabled, encrypt the archive uid as well.  */
          else if (strcmp (long_options[option_index].name, "hide-id") == 0)
          {
            if (args_info->hide_id_given)
              {
                fprintf (stderr, "%s: `--hide-id' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->hide_id_given = 1;
            args_info->hide_id_flag = !(args_info->hide_id_flag);
            break;
          }
          
          /* least output.  */
          else if (strcmp (long_options[option_index].name, "silent") == 0)
          {
            if (args_info->silent_given)
              {
                fprintf (stderr, "%s: `--silent' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->silent_given = 1; output_group_counter += 1;
          
            break;
          }
          
          /* most output.  */
          else if (strcmp (long_options[option_index].name, "debug") == 0)
          {
            if (args_info->debug_given)
              {
                fprintf (stderr, "%s: `--debug' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->debug_given = 1; output_group_counter += 1;
          
            break;
          }
          
          /* compress using given program.  */
          else if (strcmp (long_options[option_index].name, "compress") == 0)
          {
            if (args_info->compress_given)
              {
                fprintf (stderr, "%s: `--compress' option given more than once\n", CMDLINE_PARSER_PACKAGE);
                clear_args ();
                exit (EXIT_FAILURE);
              }
            args_info->compress_given = 1; compression_group_counter += 1;
          
            args_info->compress_arg = gengetopt_strdup (optarg);
            break;
          }
          

        case '?':	/* Invalid option.  */
          /* `getopt_long' already printed an error message.  */
          exit (EXIT_FAILURE);

        default:	/* bug: option not considered.  */
          fprintf (stderr, "%s: option unknown: %c\n", CMDLINE_PARSER_PACKAGE, c);
          abort ();
        } /* switch */
    } /* while */

  if ( action_group_counter != 1)
    {
      fprintf (stderr, "%s: %d options of group action were given. One is required\n", CMDLINE_PARSER_PACKAGE, action_group_counter);
      missing_required_options = 1;
    }
  
  if ( compression_group_counter > 1)
    {
      fprintf (stderr, "%s: %d options of group compression were given. At most one is required\n", CMDLINE_PARSER_PACKAGE, compression_group_counter);
      missing_required_options = 1;
    }
  
  if ( output_group_counter > 1)
    {
      fprintf (stderr, "%s: %d options of group output were given. At most one is required\n", CMDLINE_PARSER_PACKAGE, output_group_counter);
      missing_required_options = 1;
    }
  

  if ( missing_required_options )
    exit (EXIT_FAILURE);

  args_info->simulate_error_arg = (char * *) malloc (args_info->simulate_error_given * sizeof (char *));
  for (i = 0; i < args_info->simulate_error_given; i++)
    {
      args_info->simulate_error_arg [i] = simulate_error_list->simulate_error_arg;
      simulate_error_list = simulate_error_list->next;
    }
  
  if (optind < argc)
    {
      int i = 0 ;
  
      args_info->inputs_num = argc - optind ;
      args_info->inputs = 
        (char **)(malloc ((args_info->inputs_num)*sizeof(char *))) ;
      while (optind < argc)
        args_info->inputs[ i++ ] = gengetopt_strdup (argv[optind++]) ; 
    }
  
  return 0;
}
