/* $Id: check_iobuffer.c 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <check.h>

#include "iobuffer.h"

START_TEST (check_iobuffer_size)
{
  const int BUF_SIZE = 128;
  iobuffer_t *buf = create_iobuffer (BUF_SIZE);
  fail_unless (BUF_SIZE == iobuffer_size (buf));
  fail_unless (BUF_SIZE == iobuffer_free_size (buf));
  fail_unless (0 == iobuffer_data_size (buf));
}

END_TEST
START_TEST (check_iobuffer_adding)
{
  const int BUF_SIZE = 128, ADD_SIZE = 8;
  const char TEST_DATA[] = "01234567";

  iobuffer_t *buf = create_iobuffer (BUF_SIZE);

  char *free_ptr = iobuffer_free_pointer (buf);
  memcpy (free_ptr, TEST_DATA, ADD_SIZE);
  iobuffer_mark_added (buf, ADD_SIZE);

  fail_unless ((BUF_SIZE - ADD_SIZE) == iobuffer_free_size (buf));
  fail_unless (ADD_SIZE == iobuffer_data_size (buf));

  free_ptr = iobuffer_free_pointer (buf);
  memcpy (free_ptr, TEST_DATA, ADD_SIZE);
  iobuffer_mark_added (buf, ADD_SIZE);

  fail_unless ((BUF_SIZE - (2 * ADD_SIZE)) == iobuffer_free_size (buf));
  fail_unless ((2 * ADD_SIZE) == iobuffer_data_size (buf));
}

END_TEST
START_TEST (check_iobuffer_removing)
{
  const int BUF_SIZE = 128, ADD_SIZE = 8;
  char TEST_DATA[ADD_SIZE];

  for (int i = 0; i < ADD_SIZE; i++)
    TEST_DATA[i] = i;

  iobuffer_t *buf = create_iobuffer (BUF_SIZE);

  char *free_ptr = iobuffer_free_pointer (buf);
  memcpy (free_ptr, TEST_DATA, ADD_SIZE);
  iobuffer_mark_added (buf, ADD_SIZE);

  for (int i = 0; i < ADD_SIZE; i++)
    {
      const char *data_ptr = iobuffer_data_pointer (buf);
      fail_unless (*data_ptr == i);
      iobuffer_mark_taken (buf, 1);
    }
  fail_unless (BUF_SIZE == iobuffer_free_size (buf));
  fail_unless (0 == iobuffer_data_size (buf));
}
END_TEST void
add_iobuffer_tests (Suite * s)
{
  TCase *tc_core = tcase_create ("IOBuffer");

  suite_add_tcase (s, tc_core);
  tcase_add_test (tc_core, check_iobuffer_size);
  tcase_add_test (tc_core, check_iobuffer_adding);
  tcase_add_test (tc_core, check_iobuffer_removing);
}
