/* $Id: check_commandfilterio.c 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <stdbool.h>
#include <assert.h>

#include "baseio.h"
#include "selfsyncio.h"
#include "commandfilterio.h"

#include "check_io.h"
#include "check_commandfilterio.h"

#define TEST_FILE "/tmp/bumtest.commandfilterio.tmp"

START_TEST (check_out_basic)
{
  out_stream_t base_outs = baseio_open_out (TEST_FILE, "w");
  fail_if (!base_outs);

  out_stream_t outs =
    commandfilter_open_out ("/bin/cat", 4096, NULL, NULL, NULL, NULL,
                            base_outs, false);
  fail_if (!outs);

  basic_out_test (outs);
  release_out (outs);
  release_out (base_outs);
}
END_TEST static int
read_write_test_size ()
{
  switch (get_test_size ())
    {
    case QUICK_TEST:
      return 256;
    case NORMAL_TEST:
      return 1024;
    case LONG_TEST:
      return 1024 * 1024;
    default:
      fail ("Invalid test size");
      return -1;                // Not reached, prevent compiler warning
    }
}

const char escape[] = { '\0' };

static void
check_read_write (bool with_marks, int block_size)
{
  const int
    test_size = read_write_test_size (), count = test_size / block_size;

  assert (count > 0);
  assert (test_size > 0);

  out_stream_t base_outs = baseio_open_out (TEST_FILE, "w");

  if (with_marks)
    {
      base_outs = selfsync_open_out (1, escape, base_outs, false, false);
      assert (base_outs);
    }

  out_stream_t outs =
    commandfilter_open_out ("/bin/cat", 4096, NULL, NULL, NULL, NULL,
                            base_outs, false);
  ascending_output_half_test (with_marks, outs, block_size, count);
  release_out (outs);
  release_out (base_outs);

  mark_point ();

  in_stream_t base_ins = baseio_open_in (TEST_FILE, "r");
  if (with_marks)
    {
      base_ins = selfsync_open_in (1, escape, 4096, base_ins, false, false);
      assert (base_ins);
    }

  in_stream_t ins =
    commandfilter_open_in ("/bin/cat", 4096, NULL, NULL, NULL, NULL, base_ins,
                           false);
  ascending_input_half_test (true, with_marks, ins, block_size, count);
  release_in (ins);
  release_in (base_ins);
}

#define MAKE_READ_WRITE_CHECK(name, marks, block_len) \
START_TEST (name) \
{ \
  check_read_write(marks, block_len) ; \
} \
END_TEST

MAKE_READ_WRITE_CHECK (check_read_write_s, false, 1)
MAKE_READ_WRITE_CHECK (check_read_write_s_m, true, 1)
MAKE_READ_WRITE_CHECK (check_read_write_m, false, 32)
MAKE_READ_WRITE_CHECK (check_read_write_m_m, true, 32)
MAKE_READ_WRITE_CHECK (check_read_write_l, false, 256)
MAKE_READ_WRITE_CHECK (check_read_write_l_m, true, 256)
     void add_commandfilterio_tests (Suite * s)
{
  TCase *tc_core = tcase_create ("CommandFilterIO");
  tcase_set_timeout (tc_core, 30);
  tcase_add_test (tc_core, check_out_basic);
  tcase_add_test (tc_core, check_read_write_s);
  tcase_add_test (tc_core, check_read_write_s_m);
  tcase_add_test (tc_core, check_read_write_m);
  tcase_add_test (tc_core, check_read_write_m_m);
  tcase_add_test (tc_core, check_read_write_l);
  tcase_add_test (tc_core, check_read_write_l_m);

  suite_add_tcase (s, tc_core);
}
