/* $Id: unixmisc.c 658 2006-05-13 14:50:30Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#include <stdbool.h>
#include <unistd.h>
#include <fcntl.h>

#include "unixmisc.h"

bool
set_close_on_exec (int fd)
{
  int flags = fcntl (fd, F_GETFD);
  if (-1 == flags)
    return false;

  flags |= FD_CLOEXEC;
  if (-1 == fcntl (fd, F_SETFD, flags))
    return false;

  return true;
}

bool
close_on_exec_pipes (int fds[2])
{
  if (-1 == pipe (fds))
    return false;               // error creating pipe!

  // Need to set close on exec

  bool ok = true;

  ok &= set_close_on_exec (fds[0]);
  ok &= set_close_on_exec (fds[1]);

  if (!ok)
    {
      close (fds[0]);
      close (fds[1]);
      return false;
    }


  return true;
}
