/* $Id: infpipeio.h 659 2006-05-13 14:51:08Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 * This module creates pairs of input and output streams which are connected.
 * Any amount of data (that can fit in memory) can be written to the output
 * stream.  This data can be read from the input stream.
 */

#ifndef INFPIPEIO_H
#define INFPIPEIO_H

#include "nonstdio.h"

typedef struct infpipe *infpipe_t;

/* Create a new pipe.  The first two pointers are used to store the resulting
 * streams.   The third argument, if it is non-null, is used to store a handle
 * on the pipe itself, which must be freed with release_infpipe().
 */
bool infpipe_open (out_stream_t *, in_stream_t *, infpipe_t *);

#endif
