/* $Id: filestore_stats.h 722 2006-06-07 16:46:40Z jim $
   teebu - An archiving tool
   Copyright (C) 2006 Jim Farrand

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along with
   this program; if not, write to the Free Software Foundation, Inc., 51
   Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */


#ifndef FILESTORE_STATS_H
#define FILESTORE_STATS_H

#include <stdlib.h>
#include <stdbool.h>

typedef enum
{
  STAT_ROOT,

  STAT_ARCHIVE,
  STAT_ARCHIVE_WARNING,
  STAT_ARCHIVE_WARNING_UNRECOGNISED_TAG,
  STAT_ARCHIVE_ERROR,
  STAT_ARCHIVE_INPUT_ERROR,
  STAT_ARCHIVE_INPUT_ERROR_PROCESSING_STOPPED_EARLY,
  STAT_ARCHIVE_INPUT_ERROR_DATA_STOPPED_EARLY,
  STAT_ARCHIVE_INPUT_ERROR_RECOVERY,
  STAT_ARCHIVE_INPUT_ERROR_BAD_DATA,
  STAT_ARCHIVE_INPUT_ERROR_BAD_TIME,
  STAT_ARCHIVE_OUTPUT_ERROR,

  STAT_ARCHIVE_OUTPUT,
  STAT_ARCHIVE_OUTPUT_FILE,
  STAT_ARCHIVE_OUTPUT_FILE_OK,
  STAT_ARCHIVE_OUTPUT_FILE_CHECKSUM,
  STAT_ARCHIVE_OUTPUT_FILE_CHECKSUM_MD5,
  STAT_ARCHIVE_OUTPUT_FILE_CHECKSUM_SHA1,
  STAT_ARCHIVE_OUTPUT_DIR,
  STAT_ARCHIVE_OUTPUT_DIR_OK,
  STAT_ARCHIVE_OUTPUT_LINK,
  STAT_ARCHIVE_OUTPUT_LINK_OK,
  STAT_ARCHIVE_OUTPUT_SKIP,
  STAT_ARCHIVE_OUTPUT_SKIP_UNHANDLED,

  STAT_INPUT_ERROR,
  STAT_INPUT_ERROR_OPENING_FILE,
  STAT_INPUT_ERROR_STATING_FILE,
  STAT_INPUT_ERROR_OPENING_DIR,
  STAT_INPUT_ERROR_STATING_DIR,
  STAT_INPUT_ERROR_OPENING_LINK,
  STAT_INPUT_ERROR_STATING_LINK,

  STAT_VERIFY,
  STAT_VERIFY_FILE,
  STAT_VERIFY_FILE_OK,
  STAT_VERIFY_FILE_FAILED,
  STAT_VERIFY_FILE_DATA,
  STAT_VERIFY_FILE_DATA_OK,
  STAT_VERIFY_FILE_DATA_FAILED,
  STAT_VERIFY_FILE_CHECKSUM,
  STAT_VERIFY_FILE_CHECKSUM_MD5,
  STAT_VERIFY_FILE_CHECKSUM_MD5_OK,
  STAT_VERIFY_FILE_CHECKSUM_MD5_FAILED,
  STAT_VERIFY_FILE_CHECKSUM_SHA1,
  STAT_VERIFY_FILE_CHECKSUM_SHA1_OK,
  STAT_VERIFY_FILE_CHECKSUM_SHA1_FAILED,
  STAT_VERIFY_PERMISSIONS,
  STAT_VERIFY_PERMISSIONS_OK,
  STAT_VERIFY_PERMISSIONS_FAILED,
  STAT_VERIFY_MODIFICATION_TIME,
  STAT_VERIFY_MODIFICATION_TIME_OK,
  STAT_VERIFY_MODIFICATION_TIME_FAILED,
  STAT_VERIFY_CREATION_TIME,
  STAT_VERIFY_CREATION_TIME_OK,
  STAT_VERIFY_CREATION_TIME_FAILED,
  STAT_VERIFY_USER,
  STAT_VERIFY_USER_OK,
  STAT_VERIFY_USER_FAILED,
  STAT_VERIFY_GROUP,
  STAT_VERIFY_GROUP_OK,
  STAT_VERIFY_GROUP_FAILED,
  STAT_VERIFY_DIR,
  STAT_VERIFY_DIR_OK,
  STAT_VERIFY_DIR_FAILED,
  STAT_VERIFY_DIR_FAILED_NOT_FOUND,
  STAT_VERIFY_LINK,
  STAT_VERIFY_LINK_TARGET,
  STAT_VERIFY_LINK_TARGET_OK,
  STAT_VERIFY_LINK_TARGET_FAILED,

  STAT_CHECK,
  STAT_CHECK_FILE,
  STAT_CHECK_FILE_OK,
  STAT_CHECK_FILE_FAILED,

  STAT_EXTRACT,
  STAT_EXTRACT_FILE_OK,
  STAT_EXTRACT_FILE,
  STAT_EXTRACT_FILE_EXCLUDED,
  STAT_EXTRACT_FILE_FAILED,
  STAT_EXTRACT_DIR,
  STAT_EXTRACT_DIR_OK,
  STAT_EXTRACT_DIR_FAILED,
  STAT_EXTRACT_LINK,
  STAT_EXTRACT_LINK_OK,
  STAT_EXTRACT_LINK_FAILED,
  STAT_EXTRACT_LINK_EXCLUDED,

  STAT_OUTPUT_ERROR,
  STAT_OUTPUT_ERROR_WRITING_FILE,
  STAT_OUTPUT_ERROR_SETTING_FILE_TIME,
  STAT_OUTPUT_ERROR_SETTING_FILE_OWNER,
  STAT_OUTPUT_ERROR_SETTING_FILE_GROUP,

  STAT_INTERNAL_ERROR,

  STAT_OTHER
} status_t;

#define STATUS_COUNT (STAT_OTHER+1)

status_t status_parent (status_t);

typedef struct
{
  unsigned fsstat_outcomes[STATUS_COUNT];
} filestore_stats_t;

#define STAT_INCR(stats, status) ((stats) ? stats->fsstat_outcomes[status]++ : 0);

void init_filestore_stats (filestore_stats_t * stats);
void print_filestore_stats (filestore_stats_t *stats);
int compute_return_code (filestore_stats_t *stats);

#endif
