/**
 * @file misc.h
 * Header files for the memory and string management helper-functions
 *
 * Copyright (C) 2002, 2003, 2004 David Weinehall
 * Copyright (C) 2004 Free Software Foundation, Inc.
 *
 *  This file is part of GNU Sysutils
 *
 *  GNU Sysutils is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  GNU Sysutils is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _MISC_H_
#define _MISC_H_

#include <config.h>
#include <gettext.h>

/** Short form for gettext */
#define _(__str)		gettext(__str)
/** Short form for gettext_noop */
#define N_(__str)		gettext_noop(__str)

/**
 * Safe string handling; NULL will be replaced by ""
 *
 * @param __str The string
 */
#define nstr(__str) \
	__str ? __str : ""

/**
 * Safely output a long; -1 will be replaced by ""
 *
 * @param __target The file to write to
 * @param __val The value to output
 * @param __delim A string to output as a delimiter after val
 */
#define sputlval(__target, __val, __delim)			\
{								\
	if (__val != (long)-1)					\
		if (fprintf(__target, "%li", __val) < 0)	\
			return errno;				\
	if (fprintf(__target, "%s", __delim) < 0)		\
		return errno;					\
}

/**
 * Safely output a unsigned long; ~((unsigned long)0) will be replaced by ""
 *
 * @param __target The file to write to
 * @param __val The value to output
 * @param __delim A string to output as a delimiter after val
 */
#define sputulval(__target, __val, __delim)			\
{								\
	if (__val != ~((unsigned long)0))			\
		if (fprintf(__target, "%ld", __val) < 0)	\
			return errno;				\
	if (fprintf(__target, "%s", __delim) < 0)		\
		return errno;					\
}

char *strjoin(const char *delimiter, ...);
char *strjoine(const char *delimiter, ...);
char *strjoinv(const char *delimiter, char **array);
char *strjoinve(const char *delimiter, char **array);
char *strconcat(const char *str1, ...);
char **strsplit(const char *str, const char *delimiter, const int max_tokens);
void strfreev(char **array);

#endif /* _MISC_H_ */
