/**
 * @file libpasswd.h
 * Header files for common routines used by passwd and gpasswd
 *
 * Copyright (C) 2006 Free Software Foundation, Inc.
 *
 *  This file is part of GNU Sysutils
 *
 *  GNU Sysutils is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  GNU Sysutils is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef _LIBPASSWD_H_
#define _LIBPASSWD_H_

int setpasswd(const char *user, int group, int removepass, int showhash);

/** Arguments available in passwd/gpasswd */
struct setpasswd_options_t {
	const char *name;		/**< Name of user/group */
	int removepass;			/**< Remove the password */
	int showhash;			/**< Show the password hash */
};

#include <argp.h>
extern struct argp setpasswd_argp;

#endif /* _LIBPASSWD_H_ */
