/**
 * @file gshadow.h
 * Headers for a local implementation of gshadow
 * until glibc includes proper support
 *
 * Copyright (C) 2002, 2003, 2004 David Weinehall
 * Copyright (C) 2004, 2006 Free Software Foundation, Inc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library; if not, write to the Free Software Foundation,
 *  Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */
#ifndef _GSHADOW_H_
#define _GSHADOW_H_

/* Needed for FILE */
#include <stdio.h>
#include <string.h>

/** File used for the group shadow database */
#define GSHADOW_FILE	SYSCONFDIR "/gshadow"

/** Structure for group shadow entries */
struct sgrp {
	char *sg_name;		/**< Group name */
	char *sg_passwd;	/**< Password */
	char **sg_adm;		/**< Administrator list */
	char **sg_mem;		/**< Member list */
};

/* Rewind gshadow-file stream. */
extern void setsgent(void);

/* Close gshadow-file stream. */
extern void endsgent(void);

/* Read an entry from a string. */
extern struct sgrp *sgetsgent(const char *string);

/* Read an entry from the gshadow-file stream, opening it if necessary. */
extern struct sgrp *getsgent(void);

/* Read a sgrp entry from stream. */
extern struct sgrp *fgetsgent(FILE *stream);

/* Search for an entry with a matching name. */
extern struct sgrp *getsgnam(const char *name);

#endif /* _GSHADOW_H_ */
