/*  Synapse 0.1
 *  Copyright (C) 2006 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "synapse.h"

/**
	@todo	Scrivere questa funzione!
*/
gboolean open_file_selected_by_keyword ( GtkEntryCompletion *widget, GtkTreeModel *model,
						GtkTreeIter *iter, gpointer user_data ) {

	gchar *pointer;
	gchar *file_name;

	gtk_tree_model_get ( model, iter, 0, &pointer, -1 );
	file_name = strchr ( pointer, '-' ) + 2;
	gtk_entry_set_text ( GTK_ENTRY ( gtk_entry_completion_get_entry ( widget ) ), "" );

	/*********************************************************************
		questo codice e' qui solo come riempitivo a scopo dimostrativo, eliminarlo
	*/
	xfce_info ( _( "Selected file '%s'\nWorks in progress..." ), file_name );
	/*********************************************************************/

	g_free ( pointer );

	/*
		se qui tornassi FALSE interverrebbe la callback di default
		della gtk_entry_completion, che implica di settare la
		gtk_entry col valore che e' stato selezionato. Ma poco sopra
		setto esplicitamente il valore della entry alla stringa vuota,
		in modo che sia pronta ad eseguire una nuova ricerca, dunque
		andrebbe tutto in segfault...
	*/
	return TRUE;
}

/**
	@param	entry
	@param	user_data

	@return		TRUE
*/
gboolean incremental_keyword_search ( GtkEntry *entry, gpointer user_data ) {
	UINT64 fileid;
	const gchar *running;
	char *keyword;
	char *separator;
	char presentation [ 100 ];
	char filename [ 100 ];
	char list_keywords_file [ MAX_VALUE_SIZE ];
	size_t size;
	DIR *dir;
	struct dirent *file;
	struct dirent *buf;
	GtkTreeIter iter;
	GtkListStore *store;

	running = gtk_entry_get_text ( entry );
	store = ( GtkListStore* ) gtk_entry_completion_get_model ( Graph.keywords_list );
	gtk_list_store_clear ( store );

	if ( strlen ( running ) >= MIN_LENGHT_FOR_KEYWORD_SEARCH ) {
		( void ) snprintf ( presentation, 100, "%s/SELECT %llu WHERE %llu ? '%s'",
					MountedPath, AllMetadata [ META_ID ].id, AllMetadata [ META_KEYWORDS ].id, running );

		if ( ( dir = opendir ( presentation ) ) == NULL )
			xfce_err ( _( "Unable to loookup for keywords\n%s (%d)" ), strerror ( errno ), errno );

		else {
			size = dirent_buf_size ( dir );

			if ( size == -1 )
				xfce_err ( _( "Unable to loookup for keywords\n%s (%d)" ), strerror ( errno ), errno );

			else {
				if ( ( buf = calloc ( 1, size ) ) == NULL )
					return FALSE;

				while ( readdir_r ( dir, buf, &file ) == 0 && file != NULL ) {
					if ( errno != 0 ) {
						xfce_err ( _( "Error while grouping results\n%s (%d)" ), strerror ( errno ), errno );
						continue;
					}

					errno = 0;
					fileid = strtoull ( file->d_name, NULL, 10 );

					memset ( list_keywords_file, 0, sizeof ( char ) * MAX_VALUE_SIZE );
					if ( hyppo_vfs_getxattr ( fileid, META_KEYWORDS, list_keywords_file, MAX_VALUE_SIZE ) < 0 )
						continue;

					if ( ( keyword = strstr ( list_keywords_file, running ) ) == NULL )
						continue;

					if ( ( separator = strchr ( keyword, METADATA_MULTIPLE_VALUES_APPS_SEP ) ) != NULL )
						*separator = '\0';

					memset ( filename, 0, 100 );
					if ( hyppo_vfs_getxattr ( fileid, META_NAME, filename, 100 ) < 0 )
						( void ) snprintf ( filename, 100, "%s", file->d_name );

					( void ) snprintf ( presentation, 100, "%s - %s", keyword, filename );
					gtk_list_store_append ( store, &iter );
					gtk_list_store_set ( store, &iter, 0, presentation, -1 );
				}

				free ( buf );
			}

			closedir ( dir );
		}
	}

	return FALSE;
}
