/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_SHORTCUT_EDITOR_H
#define KIAZMA_SHORTCUT_EDITOR_H

#include "libkiazma.h"

#define KIAZMA_SHORTCUT_EDITOR_TYPE		( kiazma_shortcut_editor_get_type () )
#define KIAZMA_SHORTCUT_EDITOR(obj)		( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_SHORTCUT_EDITOR_TYPE, KiazmaShortcutEditor ) )
#define KIAZMA_SHORTCUT_EDITOR_CLASS(klass)	( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_SHORTCUT_EDITOR_TYPE, KiazmaShortcutEditorClass ) )
#define IS_KIAZMA_SHORTCUT_EDITOR(obj)		( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_SHORTCUT_EDITOR_TYPE ) )
#define IS_KIAZMA_SHORTCUT_EDITOR_CLASS(klass)	( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_SHORTCUT_EDITOR_TYPE ) )

typedef struct _KiazmaShortcutEditor		KiazmaShortcutEditor;
typedef struct _KiazmaShortcutEditorClass	KiazmaShortcutEditorClass;

struct _KiazmaShortcutEditor {
	GtkTable		container;
	GtkWidget		*text;
	gchar			*label;
	GdkModifierType		modifier;
	guint			key;
};

struct _KiazmaShortcutEditorClass {
	GtkTableClass		parent_class;
	void ( *kiazma_shortcut_editor ) ( KiazmaShortcutEditor *synp );
};

GType		kiazma_shortcut_editor_get_type		() G_GNUC_CONST;
GtkWidget*	kiazma_shortcut_editor_new		();
void		kiazma_shortcut_editor_get_value	( KiazmaShortcutEditor *synp, GdkModifierType *modifier, guint *key );
void		kiazma_shortcut_editor_set_value	( KiazmaShortcutEditor *synp, GdkModifierType modifier, guint key );

gchar*		kiazma_shortcuteditor_convert_num_to_string	( GdkModifierType mod, guint key );

#endif /* KIAZMA_SHORTCUT_EDITOR_H */
