/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_PERMISSIONS_H
#define KIAZMA_PERMISSIONS_H

#include "libkiazma.h"

#define KIAZMA_PERMISSIONS_TYPE			( kiazma_permissions_get_type () )
#define KIAZMA_PERMISSIONS(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_PERMISSIONS_TYPE, KiazmaPermissions ) )
#define KIAZMA_PERMISSIONS_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_PERMISSIONS_TYPE, KiazmaPermissionsClass ) )
#define IS_KIAZMA_PERMISSIONS(obj)		( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_PERMISSIONS_TYPE ) )
#define IS_KIAZMA_PERMISSIONS_CLASS(klass)	( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_PERMISSIONS_TYPE ) )

typedef struct _KiazmaPermissions	KiazmaPermissions;
typedef struct _KiazmaPermissionsClass	KiazmaPermissionsClass;

struct _KiazmaPermissions {
	GtkTable		table;
	GtkWidget		*checks [ 3 ] [ 3 ];
};

struct _KiazmaPermissionsClass {
	GtkTableClass		parent_class;
	void ( *kiazma_permissions ) ( KiazmaPermissions *synp );
};

GType		kiazma_permissions_get_type	() G_GNUC_CONST;
GtkWidget*	kiazma_permissions_new		();
void		kiazma_permissions_clear	( KiazmaPermissions *synp );
mode_t		kiazma_permissions_get_value	( KiazmaPermissions *synp );
void		kiazma_permissions_set_value	( KiazmaPermissions *synp, mode_t value );

#endif /* KIAZMA_PERMISSIONS_H */
