/*  LibKiazma 0.2
 *  Copyright (C) 2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_METADATA_SELECTOR_H
#define KIAZMA_METADATA_SELECTOR_H

#include "libkiazma.h"

#define KIAZMA_METADATA_SELECTOR_TYPE			( kiazma_metadata_selector_get_type () )
#define KIAZMA_METADATA_SELECTOR(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_METADATA_SELECTOR_TYPE, KiazmaMetadataSelector ) )
#define KIAZMA_METADATA_SELECTOR_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_METADATA_SELECTOR_TYPE, KiazmaMetadataSelectorClass ) )
#define IS_KIAZMA_METADATA_SELECTOR(obj)		( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_METADATA_SELECTOR_TYPE ) )
#define IS_KIAZMA_METADATA_SELECTOR_CLASS(klass)	( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_METADATA_SELECTOR_TYPE ) )

typedef struct _KiazmaMetadataSelector			KiazmaMetadataSelector;
typedef struct _KiazmaMetadataSelectorClass		KiazmaMetadataSelectorClass;

struct _KiazmaMetadataSelector {
	GtkComboBox		main_win;
};

struct _KiazmaMetadataSelectorClass {
	GtkComboBoxClass	parent_class;
	void ( *kiazma_metadata_selector )	( KiazmaMetadataSelector *synp );
};

GType		kiazma_metadata_selector_get_type			() G_GNUC_CONST;
GtkWidget*	kiazma_metadata_selector_new				();
GtkWidget*	kiazma_metadata_selector_new_full			();
void		kiazma_metadata_selector_add_meta			( KiazmaMetadataSelector *item, UINT64 meta );
void		kiazma_metadata_selector_remove_meta			( KiazmaMetadataSelector *item, UINT64 meta );
UINT64		kiazma_metadata_selector_get				( KiazmaMetadataSelector *item );
void		kiazma_metadata_selector_set				( KiazmaMetadataSelector *item, UINT64 meta );

#endif /* KIAZMA_METADATA_SELECTOR_H */
