/*  LibKiazma 0.2
 *  Copyright (C) 2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_INPUT_DIALOG_H
#define KIAZMA_INPUT_DIALOG_H

#include "libkiazma.h"

#define KIAZMA_INPUT_DIALOG_TYPE			( kiazma_input_dialog_get_type () )
#define KIAZMA_INPUT_DIALOG(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_INPUT_DIALOG_TYPE, KiazmaInputDialog ) )
#define KIAZMA_INPUT_DIALOG_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_INPUT_DIALOG_TYPE, KiazmaInputDialogClass ) )
#define IS_KIAZMA_INPUT_DIALOG(obj)			( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_INPUT_DIALOG_TYPE ) )
#define IS_KIAZMA_INPUT_DIALOG_CLASS(klass)		( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_INPUT_DIALOG_TYPE ) )

typedef struct _KiazmaInputDialog			KiazmaInputDialog;
typedef struct _KiazmaInputDialogClass			KiazmaInputDialogClass;

struct _KiazmaInputDialog {
	GtkDialog		main_win;
	GtkWidget		*icon;
	GtkWidget		*text;
	GtkWidget		*user_container;
};

struct _KiazmaInputDialogClass {
	GtkDialogClass		parent_class;
	void ( *kiazma_input_dialog )	( KiazmaInputDialog *synp );
};

GType		kiazma_input_dialog_get_type			() G_GNUC_CONST;
GtkWidget*	kiazma_input_dialog_new				( gchar *title, gchar *text, GtkMessageType type, GtkButtonsType buttons, GtkWidget *input, ... );

#endif /* KIAZMA_INPUT_DIALOG_H */
