/*  LibKiazma 0.2
 *  Copyright (C) 2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_ICON_H
#define KIAZMA_ICON_H

#include "libkiazma.h"

#define KIAZMA_ICON_TYPE			( kiazma_icon_get_type () )
#define KIAZMA_ICON(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_ICON_TYPE, KiazmaIcon ) )
#define KIAZMA_ICON_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_ICON_TYPE, KiazmaIconClass ) )
#define IS_KIAZMA_ICON(obj)			( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_ICON_TYPE ) )
#define IS_KIAZMA_ICON_CLASS(klass)		( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_ICON_TYPE ) )

#define KIAZMA_ICON_MIN_SIZE			30

typedef struct _KiazmaIcon			KiazmaIcon;
typedef struct _KiazmaIconClass			KiazmaIconClass;

struct _KiazmaIcon {
	KiazmaWidget		main;
	GList			*props;
};

struct _KiazmaIconClass {
	KiazmaWidgetClass	parent_class;
	void ( *kiazma_icon )	( KiazmaIcon *item );
};

GType		kiazma_icon_get_type		() G_GNUC_CONST;
GtkWidget*	kiazma_icon_new			( UINT64 file, ... );
GtkWidget*	kiazma_icon_new_list		( UINT64 file, GList *list );

GdkPixbuf*	kiazma_icon_prerender		( KiazmaIcon *icon );

#endif /* KIAZMA_ICON_H */
