/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/**
	@file	kiazma_hour.c
*/

#include "libkiazma.h"
#include "kiazma_hour.h"
#include <langinfo.h>

/**
	Init the GTK class rappresenting the KiazmaHour

	@param	klass	The new class to init
*/
static void kiazma_hour_class_init ( KiazmaHourClass *klass ) {
}

/**
	Init the GTK widgets that compose the KiazmaHour

	@param	ttt	The KiazmaHour to init
*/
static void kiazma_hour_init ( KiazmaHour *ttt ) {
	gchar *format;

	/**
		@warning	To determine the format to use, is used nl_langinfo(3),
				which is not thread-safe
	*/
	format = nl_langinfo ( D_T_FMT );

	if ( strstr ( format, "%r" ) ) {
		ttt->format = FORMAT_12_HOUR;

		ttt->hour = g_new0 ( GtkWidget*, 4 );
		ttt->hour [ 0 ] = gtk_spin_button_new_with_range ( 0, 12, 1 );
		ttt->hour [ 1 ] = gtk_spin_button_new_with_range ( 0, 59, 1 );
		ttt->hour [ 2 ] = gtk_spin_button_new_with_range ( 0, 59, 1 );

		ttt->hour [ 3 ] = gtk_combo_box_new_text ();
		gtk_combo_box_append_text ( GTK_COMBO_BOX ( ttt->hour [ 3 ] ), "AM" );
		gtk_combo_box_append_text ( GTK_COMBO_BOX ( ttt->hour [ 3 ] ), "PM" );
		gtk_combo_box_set_active ( GTK_COMBO_BOX ( ttt->hour [ 3 ] ), 0 );

		gtk_box_pack_start ( GTK_BOX ( &( ttt->main_win ) ), ttt->hour [ 0 ], TRUE, TRUE, 0 );
		gtk_box_pack_start ( GTK_BOX ( &( ttt->main_win ) ), ttt->hour [ 1 ], TRUE, TRUE, 0 );
		gtk_box_pack_start ( GTK_BOX ( &( ttt->main_win ) ), ttt->hour [ 2 ], TRUE, TRUE, 0 );
		gtk_box_pack_start ( GTK_BOX ( &( ttt->main_win ) ), ttt->hour [ 3 ], TRUE, TRUE, 0 );
	}

	else /* %R or %T */ {
		ttt->format = FORMAT_24_HOUR;

		ttt->hour = g_new0 ( GtkWidget*, 3 );
		ttt->hour [ 0 ] = gtk_spin_button_new_with_range ( 0, 23, 1 );
		ttt->hour [ 1 ] = gtk_spin_button_new_with_range ( 0, 59, 1 );
		ttt->hour [ 2 ] = gtk_spin_button_new_with_range ( 0, 59, 1 );

		gtk_box_pack_start ( GTK_BOX ( &( ttt->main_win ) ), ttt->hour [ 0 ], TRUE, TRUE, 0 );
		gtk_box_pack_start ( GTK_BOX ( &( ttt->main_win ) ), ttt->hour [ 1 ], TRUE, TRUE, 0 );
		gtk_box_pack_start ( GTK_BOX ( &( ttt->main_win ) ), ttt->hour [ 2 ], TRUE, TRUE, 0 );
	}
}

/**
	Return the GType of the widget KiazmaHour

	@return		The type of widget for KiazmaHour
*/
GType kiazma_hour_get_type () {
	static GType ttt_type = 0;

	if ( !ttt_type ) {
		static const GTypeInfo ttt_info = {
			sizeof ( KiazmaHourClass ),
			NULL,
			NULL,
			( GClassInitFunc ) kiazma_hour_class_init,
			NULL,
			NULL,
			sizeof ( KiazmaHour ),
			0,
			( GInstanceInitFunc ) kiazma_hour_init,
		};

		ttt_type = g_type_register_static ( GTK_TYPE_HBOX, "KiazmaHour", &ttt_info, 0 );
	}

	return ttt_type;
}

/**
	Creates a new KiazmaHour

	@return		A new KiazmaHour
*/
GtkWidget* kiazma_hour_new () {
	return GTK_WIDGET ( g_object_new ( kiazma_hour_get_type (), NULL ) );
}

/**
	Reset the value into a KiazmaHour to the default

	@param	item	The KiazmaHour to reset
*/
void kiazma_hour_clear ( KiazmaHour *item ) {
	kiazma_hour_set_value ( item, time ( NULL ) );
}

/**
	Used to retrive the value manipulated with a KiazmaHour

	@param	item	The KiazmaHour from which get the value

	@return		The time expressed from the value inside the widget,
			in Unix time. The value rappresents the selected hour
			for the day 0 in the Epoch (January, 1 1970)
*/
time_t kiazma_hour_get_value ( KiazmaHour *item ) {
	time_t ret			= 0;

	ret = ( ( int ) gtk_spin_button_get_value ( GTK_SPIN_BUTTON ( item->hour [ 0 ] ) ) * 3600 ) +
		( ( int ) gtk_spin_button_get_value ( GTK_SPIN_BUTTON ( item->hour [ 1 ] ) ) * 60 ) +
		( int ) gtk_spin_button_get_value ( GTK_SPIN_BUTTON ( item->hour [ 2 ] ) );

	if ( item->format == FORMAT_12_HOUR && gtk_combo_box_get_active ( GTK_COMBO_BOX ( item->hour [ 3 ] ) ) == 1 )
		ret += ( 12 * 3600 );

	return ret;
}

/**
	To init the value inside a KiazmaHour

	@param	item	The KiazmaHour where to set the value
	@param	value	The value to set into the widget, expressed as Unix
			time. It is considered only the hour expressed, the
			calendar day is ignored
*/
void kiazma_hour_set_value ( KiazmaHour *item, time_t value ) {
	struct tm stm;

	if ( localtime_r ( &value, &stm ) == NULL )
		return;

	gtk_spin_button_set_value ( GTK_SPIN_BUTTON ( item->hour [ 1 ] ), ( gdouble ) stm.tm_min );
	gtk_spin_button_set_value ( GTK_SPIN_BUTTON ( item->hour [ 2 ] ), ( gdouble ) stm.tm_sec );

	if ( item->format == FORMAT_12_HOUR ) {
		if ( stm.tm_hour > 12 ) {
			gtk_spin_button_set_value ( GTK_SPIN_BUTTON ( item->hour [ 0 ] ), ( gdouble ) stm.tm_hour - 12 );
			gtk_combo_box_set_active ( GTK_COMBO_BOX ( item->hour [ 3 ] ), 1 );
		}
		else {
			gtk_spin_button_set_value ( GTK_SPIN_BUTTON ( item->hour [ 0 ] ), ( gdouble ) stm.tm_hour );
			gtk_combo_box_set_active ( GTK_COMBO_BOX ( item->hour [ 3 ] ), 0 );
		}
	}
	else
		gtk_spin_button_set_value ( GTK_SPIN_BUTTON ( item->hour [ 0 ] ), ( gdouble ) stm.tm_hour );
}
