/*  LibKiazma 0.2
 *  Copyright (C) 2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_DRAWING_AREA_H
#define KIAZMA_DRAWING_AREA_H

#include "libkiazma.h"

#define KIAZMA_DRAWING_AREA_TYPE			( kiazma_drawing_area_get_type () )
#define KIAZMA_DRAWING_AREA(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_DRAWING_AREA_TYPE, KiazmaDrawingArea ) )
#define KIAZMA_DRAWING_AREA_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_DRAWING_AREA_TYPE, KiazmaDrawingAreaClass ) )
#define IS_KIAZMA_DRAWING_AREA(obj)			( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_DRAWING_AREA_TYPE ) )
#define IS_KIAZMA_DRAWING_AREA_CLASS(klass)		( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_DRAWING_AREA_TYPE ) )

typedef struct _KiazmaDrawingArea			KiazmaDrawingArea;
typedef struct _KiazmaDrawingAreaClass			KiazmaDrawingAreaClass;

struct _KiazmaDrawingArea {
	GtkDrawingArea			combo;
	GdkPixmap			*pixmap;
};

struct _KiazmaDrawingAreaClass {
	GtkDrawingAreaClass			parent_class;
	void ( *kiazma_drawing_area )		( KiazmaDrawingArea *synp );
};

GType		kiazma_drawing_area_get_type			() G_GNUC_CONST;
GtkWidget*	kiazma_drawing_area_new				();
GdkPixmap*	kiazma_drawing_area_get_draw			( KiazmaDrawingArea *area );

#endif /* KIAZMA_DRAWING_AREA_H */
