/*  LibKiazma 0.2
 *  Copyright (C) 2006/2007 Roberto -MadBob- Guido <m4db0b@users.sourceforge.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef KIAZMA_ALIGNED_H
#define KIAZMA_ALIGNED_H

#include "libkiazma.h"

#define KIAZMA_ALIGNED_TYPE			( kiazma_aligned_get_type () )
#define KIAZMA_ALIGNED(obj)			( G_TYPE_CHECK_INSTANCE_CAST ( ( obj ), KIAZMA_ALIGNED_TYPE, KiazmaFrame ) )
#define KIAZMA_ALIGNED_CLASS(klass)		( G_TYPE_CHECK_CLASS_CAST ( ( klass ), KIAZMA_ALIGNED_TYPE, KiazmaAlignedClass ) )
#define IS_KIAZMA_ALIGNED(obj)			( G_TYPE_CHECK_INSTANCE_TYPE ( ( obj ), KIAZMA_ALIGNED_TYPE ) )
#define IS_KIAZMA_ALIGNED_CLASS(klass)		( G_TYPE_CHECK_CLASS_TYPE ( ( klass ), KIAZMA_ALIGNED_TYPE ) )

typedef struct _KiazmaAligned			KiazmaAligned;
typedef struct _KiazmaAlignedClass		KiazmaAlignedClass;

struct _KiazmaAligned {
	GtkHBox			box;
};

struct _KiazmaAlignedClass {
	GtkHBoxClass		parent_class;
	void ( *kiazma_aligned ) ( KiazmaAligned *synp );
};

GType		kiazma_aligned_get_type			() G_GNUC_CONST;
GtkWidget*	kiazma_aligned_new			( GtkSizeGroup *sg, gchar *title, GtkWidget *item );

#endif /* KIAZMA_ALIGNED_H */
