// (C) Benedikt Stefansson - V 1.0 January 1998 benedikt@ucla.edu
// Distribute freely under the terms of the GNU Public License

#import "Script.h"

@implementation Script

+createBegin: (id) aZone {
  Script * obj;
  // First, call our superclass createBegin 
  obj = [super createBegin: aZone];

  return obj;
}

-setFile: (char *) aFileName {

  theFileObject = [InFile create: [self getZone] withName: aFileName] ;

  return self;
}

-logEvents: (char *) aLogName {
  time_t lt;
  
  logEvents=1;
  outfile=fopen(aLogName,"w");

  lt=time(NULL);
  
  fprintf(outfile,"# Generated  ");
  fprintf(outfile,asctime(localtime(&lt)));
  fprintf(outfile,"@begin\n");
  
  return self;
}

-createEnd {
   
  return [super createEnd];
}

-(void) crash: (char *) m line: (int) l {
  fprintf(stderr,"Script crashed at line %d because:  %s\n",l,m);

  //exit(1) ;
}

-buildActions: (id) m {
  id modelProbe;
  id probedObjectAccess;
  id probedObject;
  id aProbeMap;
  id aProbe;
  id aSchedule;
  id anEvent;
  id eventList;
  char aChar;
  char aString[80];
  int i;
  int lines;
  int eventTime;
  int lastEvent=0;
  int targetIsModel;
  
  // modelProbe=[m getCompleteProbeMap];
  modelProbe=[probeLibrary getCompleteProbeMapFor: [m class]];
  
  eventList=[List create: [self getZone]];
  scheduleList=[List create: [self getZone]];

  if(theFileObject==NULL) {
    fprintf(stderr,"Script crashed because no file provided\n");
    exit(1);
  }
  
  while(1){
    
    while(1){
      // File should begin with a comment "# Comment ..." or "@begin"
      if(!([theFileObject getChar: &aChar]))
        [self crash: "because file didn't start with a character" line: lines] ;

      if(aChar == '#'){
	lines++;
        if(![theFileObject skipLine])
          [self crash: "reading comment line" line: lines] ;
      } else {
        if(![theFileObject unGetChar: aChar])
          [self crash: "reading comment line" line: lines] ;
        break ;
      }
    }

    // OK that was not a comment - so is it @begin ?
    if(![theFileObject getWord: aString])
      [self crash: "reading first string" line: lines] ;
   
    if( (aString[0] == '@') && 
        (aString[1] == 'b') &&
        (aString[2] == 'e') &&
        (aString[3] == 'g') &&
        (aString[4] == 'i') &&
        (aString[5] == 'n') ) {
      lines++;
      if(![theFileObject skipLine])
        [self crash: "nothing after begin" line: lines] ;   
      break ;
    }
  }
  

  while(1){
   
     while(1){ 

      if(!([theFileObject getChar: &aChar]))
	break;
        // [self crash: "expected line, comment or end" line: lines] ;

      if(aChar == '#'){
	lines++;
        if(![theFileObject skipLine])
          [self crash: "expected line, comment or end" line: lines] ;
      } else {
        if(![theFileObject unGetChar: aChar])
          [self crash: "expected line, comment or end" line: lines] ;
        break ;
      }
    }

    // Create an event object
    anEvent=[ScriptEvent create:[self getZone]];

 
    // Get the name of the object to send the message to
    if(![theFileObject getWord: aString])
      [self crash: "expected \"model\" or \"getX\" function to access target X in Swarm" line: lines] ;

    if( (aString[0] == '@') && 
        (aString[1] == 'e') &&
        (aString[2] == 'n') &&
        (aString[3] == 'd') ) {
      [theFileObject skipLine] ; 
                                 
      break ;
    }
    
    if(!( (aString[0] == 'm') && 
          (aString[1] == 'o') &&
          (aString[2] == 'd') &&

          (aString[3] == 'e') &&
          (aString[4] == 'l')    ) ) {

      // Assume the string is the "get Method" for target name
      // and call the modelSwarm to get a pointer to the object
      probedObjectAccess=[modelProbe getProbeForMessage: aString];
      probedObject=(id)[probedObjectAccess intDynamicCallOn: m];
    
      if( !probedObject )
	[self crash: "expected \"getX\" function to access target X in Swarm" line: lines] ;

      // Now set the target to probedObject
      [anEvent setObject: probedObject name: aString];
    
      // Get a probeMap for the object 
      aProbeMap=[probedObject getProbeMap];

      // Set target
      targetIsModel=0;
      
    } else {
      // Assume the target is the Swarm creating me
      aProbeMap=modelProbe;

      // Set target;
      targetIsModel=1;

      // Notify the event
      [anEvent setObject: m name: "model"];
      [anEvent setProbeMap: modelProbe];
    }

    // The next piece of information should
    // be an integer - the time of the event
    if(![theFileObject getWord: aString] || isalpha(aString[0]))
      [self crash: "expected time value" line: lines];
        
     // Set the time of the event
    [anEvent setTime: aString];
    
     
    // Get a name for the method to probe
    if(![theFileObject getWord: aString])
      [self crash: "expected method name in target object" line: lines];

    if(!targetIsModel) {
      if(!(aProbe=[aProbeMap getProbeForMessage: aString]))
	[self crash: "couldn't probe target object" line: lines];
    } else {
      if(!(aProbe=[modelProbe getProbeForMessage: aString]))
	[self crash: "couldn't probe target (the Swarm)" line: lines];
    }

    [anEvent setMessage: aString];

    // Get the argument(s) that we should send
    if(!([aProbe getArgNum]==0)) {
      for(i=0;i<[aProbe getArgNum];i++) {
	if(![theFileObject getWord: aString] || isalpha(aString[0]))
	  [self crash: "expected argument value for method in target" line: lines];
	[anEvent setArgument: aString];
      }
    }
      
    // Now add this event to the list
    if(logEvents==1) 
      [anEvent setLogFile: outfile];
    [eventList addLast: anEvent];
    
    if(![theFileObject skipLine])
      [self crash: "problems with end of file" line: lines] ;
    lines++;

  }
  // Now create the schedules
  for(i=0;i<[eventList getCount];i++) {
    anEvent=[eventList atOffset: i];
    eventTime=[anEvent getTime];
    aSchedule=[Schedule createBegin: [self getZone]];
    aSchedule=[aSchedule createEnd];
    [aSchedule at: eventTime
	       createActionTo: anEvent
	       message: M(execute)];
    [scheduleList addLast: aSchedule];

    if(eventTime>lastEvent)
      lastEvent=eventTime;
  }

  // Finally create a schedule to close logfile
  aSchedule = [Schedule create: [self getZone]];
  [aSchedule at: lastEvent
    createActionTo: self 
         message: M(closeLogFile)];
  [scheduleList addLast: aSchedule];
  
  [eventList drop];

  return self;


  
}

-activateIn: (id) swarmContext {
  int i;
  
  
  [super activateIn: swarmContext];
  
  // Now activate our own schedules
  for(i=0;i<[scheduleList getCount];i++) 
    [[scheduleList atOffset: i] activateIn: self];
  
  // Finally, return our activity.
  return [self getSwarmActivity];
}

-closeLogFile {

  if(logEvents==1) {
    fprintf(outfile,"@end");
    fclose(outfile);
  }
  return self;
  
}


@end

@implementation ScriptEvent

-setTime: (char *) t {
  theTime= atoi(t);
  return self;
}

-setLogFile: (FILE *) f {
  logEvents=1;
  outfile=f;

  return self;
}

-(int)getTime {
  return theTime;
}

-setObject: (id) o name: (const char *) n {
  theTarget=o;
  theName=strdup(n);
  return self;
}

-setProbeMap: (id) m {
  theProbeMap=m;
  return self;
}

-setMessage: (char *) s {
  theMessage=strdup(s);
  return self;
}

-setArgument: (char *) s {
  EventArgument * arg;
  
  if(!argumentList)
    argumentList=[List create: [self getZone]];
  
  arg=[[EventArgument create: [self getZone]] setArg: s];
  [argumentList addLast: arg];
  
  return self;
}

-execute {
  id aProbeMap;
  id aProbe;
  int i;
  
  if(!theProbeMap)
    aProbeMap=[theTarget getProbeMap];
  else
    aProbeMap=theProbeMap;
  
  aProbe=[aProbeMap getProbeForMessage: theMessage];

  if(!([aProbe getArgNum]==0))
    for(i=0;i<[aProbe getArgNum];i++) 
      [aProbe setArg: i To: (char *)[[argumentList atOffset: i] getArg]];
  
  [aProbe dynamicCallOn: theTarget];
    
  if(logEvents==1) {
      fprintf(outfile,"%s %d %s ",theName,theTime,theMessage);
      for(i=0;i<[aProbe getArgNum];i++) 
	fprintf(outfile,"%s ",(char *)[[argumentList atOffset: i] getArg]);
      fprintf(outfile,"\n");
  }
  
  return self;
}

@end

@implementation EventArgument

-setArg: (char *) a {
   theArgument=strdup(a);

   return self;
}

-(char *)getArg {
  return theArgument;
}

@end
