// (C) Benedikt Stefansson - V 1.0 January 1998 benedikt@ucla.edu
// Distribute freely under the terms of the GNU Public License

#import <swarmobject.h>
#import <simtools.h>
#import <activity.h>
#import <collections.h>
#import <math.h>
#import <stdio.h>
#import <stdlib.h>
#import <string.h>
#import <time.h>
#import <ctype.h>

@class Script;
@class ScriptEvent;
@class EventArgument;

@interface Script: Swarm {
  id theFileObject;
  id scheduleList;
  int logEvents;
  FILE * outfile;
}

+createBegin: (id) aZone;
-createEnd;

-logEvents: (char *) aLogName;
-setFile: (char *) aFileName;


-(void)crash: (char *) m line: (int) l;

-buildActions: (id) m; 
-activateIn: (id) swarmContext;

-closeLogFile;

@end

@interface ScriptEvent: Swarm {
  int theTime;
  id theTarget;
  id theProbeMap;
  char * theMessage;
  char * theName;
  int logEvents;
  id <List> argumentList;
  FILE * outfile;
}

-setTime: (char *) t;
-(int)getTime;
-setLogFile: (FILE *) f;

-setObject: (id) o name: (const char *) n;
-setProbeMap: (id) m;
-setMessage: (char *) s;

-setArgument: (char *) s;

-execute;

@end

@interface EventArgument: SwarmObject {
  char * theArgument;
}

-setArg: (char *) a;
-(char *)getArg;

@end
