/*$$
 * packages uchicago.src.*
 * Copyright (c) 1999, Trustees of the University of Chicago
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with 
 * or without modification, are permitted provided that the following 
 * conditions are met:
 *
 *	 Redistributions of source code must retain the above copyright notice,
 *	 this list of conditions and the following disclaimer.
 *
 *	 Redistributions in binary form must reproduce the above copyright notice,
 *	 this list of conditions and the following disclaimer in the documentation
 *	 and/or other materials provided with the distribution.
 *
 *	 Neither the name of the University of Chicago nor the names of its
 *   contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE TRUSTEES OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Nick Collier
 * nick@src.uchicago.edu
 *
 * packages cern.jet.random.*
 * Copyright (c) 1999 CERN - European Laboratory for Particle
 * Physics. Permission to use, copy, modify, distribute and sell this
 * software and its documentation for any purpose is hereby granted without
 * fee, provided that the above copyright notice appear in all copies
 * and that both that copyright notice and this permission notice appear in
 * supporting documentation. CERN makes no representations about the 
 * suitability of this software for any purpose. It is provided "as is" 
 * without expressed or implied warranty. 
 *
 * Wolfgang Hoschek
 * wolfgang.hoschek@cern.ch
 *$$*/
package gui;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.*;
import java.util.Vector;
import java.io.DataOutputStream;

//import com.sun.image.codec.jpeg.*;
import Acme.JPM.Encoders.GifEncoder;
import uchicago.src.sim.util.SimUtilities;

/**
 * Used by DisplaySurface to do the actual painting of displayables. A
 * typical user should never use this class directly.
 *
 * @author Nick Collier
 * @version $Revision: 1.1.1.1 $ $Date: 2000/03/10 03:16:24 $
 */

public class LocalPainter extends Painter {

  /**
   * Creates a LocalPainter using the specified displaySurface, and with
   * the specified width and height.
   *
   * @param s the displaySurface associated with this LocalPainter
   * @param w the width of the painter
   * @param h the height of the painter
   */
  public LocalPainter(DisplaySurface s, int w, int h) {
    super(s, w, h);
  }

  /**
   * Paints all the displayables on the screen in the order they were
   * added to the display surface
   */
  public void paint(Graphics g) {

    if (buffImage == null) {
      createBufferedImage();
    }

    // new
    createGraphics2D();

    // if background is not painted every tick then
    // displaySurface view menu won't update correctly.
    paintBackground();

    simGraphics.setGraphics(g2);
    simGraphics.setDisplaySurface(surface);

    for (int i = 0; i < displayables.size(); i++) {
      Displayable dis = (Displayable) displayables.elementAt(i);
      dis.drawDisplay (simGraphics);
    }

    g2.dispose();

    g.drawImage(buffImage, 0, 0, null);
    toolkit.sync();
  }

  /**
   * Takes a snapshot of the current screen image and writes it to the
   * specified output stream
   *
   * @param os the OutputStream to write the snapshot to
   */
  public void takeSnapshot(DataOutputStream os) {
    try {
      GifEncoder encoder = new GifEncoder(buffImage, os);
      encoder.encode();
      encoder = null;
    } catch (java.io.IOException ex) {
      SimUtilities.showError("Unable to write snapshot image to file", ex);
      ex.printStackTrace();
    }
  }
}
