# $Id: google-stations.py,v 1.38 2004/01/31 17:52:44 jylefort Exp $
#
# Copyright (c) 2003, 2004 Jean-Yves Lefort
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
#    may be used to endorse or promote products derived from this software
#    without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
# CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
# INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
# MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
# BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
# EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
# TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
# ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

import gettext, re, os, G, ST

FIELD_TITLE 		= 0
FIELD_DESCRIPTION	= 1
FIELD_URL 		= 2

GOOGLE_DIRECTORY_ROOT	= "http://directory.google.com"
CATEGORIES_URL_POSTFIX	= "/Top/Arts/Music/Sound_Files/MP3/Streaming/Stations/"

GOOGLE_STATIONS_HOME	= GOOGLE_DIRECTORY_ROOT + CATEGORIES_URL_POSTFIX

re_category	= re.compile('^<a href="(.*)">(<b>)?(.*?)(</b>)?</a>&nbsp;')
re_stream	= re.compile('^<td><font face="arial,sans-serif"><a href="(.*)">(.*)</a>')
re_description	= re.compile('^<br><font size=-1> (.*?)</font>')

def _ (message):
    return gettext.dgettext("streamtuner-python", message)

class RefreshInfo:
    def __init__ (self, streams):
        self.stream = None
        self.streams = streams

def to_utf8 (str):
    # Google returns no charset information in the Content-Type HTTP
    # header, so we assume that the data is encoding in ISO8859-1
    return unicode(str, "iso-8859-1").encode("utf8")
    
def refresh_cb (category, categories, streams, data):
    global GOOGLE_DIRECTORY_ROOT

    session = ST.Transfer.Session()
    if session.get_by_line(GOOGLE_DIRECTORY_ROOT + CATEGORIES_URL_POSTFIX,
                           0,
                           None,
                           None,
                           categories_line_cb,
                           categories) is None:
        return None                     # transfer aborted
    
    if category.url_postfix is not None:
        if session.get_by_line(GOOGLE_DIRECTORY_ROOT + category.url_postfix,
                               0,
                               None,
                               None,
                               streams_line_cb,
                               RefreshInfo(streams)) is None:
            return None                 # transfer aborted

    return 1

def categories_line_cb (line, categories):
    global re_category
    global CATEGORIES_URL_POSTFIX
    
    match = re_category.match(line)
    if match is not None:
        category = ST.Category()

        category.name = to_utf8(match.group(3))
        category.label = to_utf8(match.group(3))

        href = to_utf8(match.group(1))

        if href[0] == "/":
            category.url_postfix = href
        else:
            category.url_postfix = CATEGORIES_URL_POSTFIX + href
            
        categories.append(G.Node(category))

def streams_line_cb (line, info):
    match = re_stream.match(line)
    if match is not None:
        if info.stream is not None:
            ST.notice(_("Google Stations: found incomplete stream"))
        else:
            info.stream = ST.Stream()
            info.stream.name = to_utf8(match.group(1))	# we use url as name
            info.stream.set_field(FIELD_URL, to_utf8(match.group(1)))
            info.stream.set_field(FIELD_TITLE, to_utf8(match.group(2)))
    else:
        match = re_description.match(line)
        if match is not None:
            if info.stream is None:
                ST.notice(_("Google Stations: found misplaced description"))
            else:
                info.stream.set_field(FIELD_DESCRIPTION, to_utf8(match.group(1)))
                info.streams.append(info.stream)
                info.stream = None
        
def browse_cb (stream, data):
    ST.Action.run("view-web", stream.get_field(FIELD_URL))
    return 1

def init_handler ():
    stock_categories = G.Node()
    
    category = ST.Category()
    category.name = "__main"
    category.label = _("Internet radios")
    category.url_postfix = "/Top/Arts/Radio/Internet/"
    
    stock_categories.append(G.Node(category))
     
    handler = ST.Handler("google-stations.py")
    handler.label = _("Google Stations")
    handler.copyright = "Copyright (c) 2003, 2004 Jean-Yves Lefort"
    handler.description = _("Google Stations")
    handler.home = GOOGLE_STATIONS_HOME
    handler.stock_categories = stock_categories
    
    icon = ST.find_icon("google-stations.png")
    if icon is not None:
        handler.icon = icon
    else:
        ST.notice(_("Google Stations: unable to find icon file"))

    handler.add_field(ST.HandlerField(FIELD_TITLE, _("Title"), G.TYPE_STRING, 1))
    handler.add_field(ST.HandlerField(FIELD_DESCRIPTION, _("Description"), G.TYPE_STRING, 1))
    handler.add_field(ST.HandlerField(FIELD_URL, _("URL"), G.TYPE_STRING, 0))
    
    handler.bind(ST.Handler.EVENT_REFRESH, refresh_cb)
    handler.bind(ST.Handler.EVENT_STREAM_BROWSE, browse_cb)
    
    ST.Handlers.add(handler)

def init ():
    gettext.bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);

    if not ST.check_api_version(0, 2):
        raise RuntimeError, _("API version mismatch")

    init_handler()
    ST.Action.register("view-web", _("Browse a website"), "epiphany %q")

init()
