/*
 * $Id: st-stream-store.h,v 1.10 2004/03/27 21:25:03 jylefort Exp $
 *
 * Copyright (c) 2004 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ST_STREAM_STORE_H
#define _ST_STREAM_STORE_H

#include <gtk/gtk.h>
#include "st-handler-api.h"
#include "st-stream-bag.h"

#define ST_TYPE_STREAM_STORE			(st_stream_store_get_type())
#define ST_STREAM_STORE(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), ST_TYPE_STREAM_STORE, STStreamStore))
#define ST_STREAM_STORE_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), ST_TYPE_STREAM_STORE, STStreamStoreClass))
#define ST_IS_STREAM_STORE(obj)			(G_TYPE_CHECK_INSTANCE_TYPE((obj), ST_TYPE_STREAM_STORE))
#define ST_IS_STREAM_STORE_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE((klass), ST_TYPE_STREAM_STORE))
#define ST_STREAM_STORE_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), ST_TYPE_STREAM_STORE, STStreamStoreClass))

enum {
  ST_STREAM_STORE_COLUMN_BAG,
  ST_STREAM_STORE_COLUMN_STOCK_ID,
  ST_STREAM_STORE_COLUMN_PIXBUF,
  ST_STREAM_STORE_N_STOCK_COLUMNS
};

typedef struct _STStreamStorePrivate STStreamStorePrivate;

typedef struct
{
  GtkListStore		store;

  STStreamStorePrivate	*priv;
} STStreamStore;

typedef struct
{
  GtkListStoreClass	parent_class;
} STStreamStoreClass;

typedef gboolean (STStreamStoreForeachCallback) (STStreamStore *store,
						 STStreamBag *bag,
						 gpointer data);

GType		st_stream_store_get_type	(void);
STStreamStore	*st_stream_store_new		(STHandler	*handler);

void		st_stream_store_append		(STStreamStore	*store,
						 STStreamBag	*bag);
void		st_stream_store_append_list	(STStreamStore	*store,
						 GSList		*list);
void		st_stream_store_foreach		(STStreamStore	*store,
						 STStreamStoreForeachCallback *cb,
						 gpointer	data);
int		st_stream_store_count		(STStreamStore	*store);

gboolean	st_stream_store_search_equal_func (GtkTreeModel	*model,
						   int		column,
						   const char	*key,
						   GtkTreeIter	*iter,
						   gpointer	search_data);

#endif /* _ST_STREAM_STORE_H */
