#!/usr/bin/python
import os, sys

#######################################
def daemonize(pidfile=None, return_child=False):
	# First fork
	try: 
		pid = os.fork() 
		if pid > 0: os._exit(0)
	except OSError, detail: 
		error("fork #1 failed: (%d) %s\n" % (detail.errno, detail.strerror))
		os_exit(1)
		
	# Decouple from parent environment.
	os.chdir("/") 
	os.umask(0) 
	os.setsid() 
	
	# Do second fork.
	try: 
		pid = os.fork() 
		if pid > 0:
			if return_child: return pid
			else: os._exit(0)
	except OSError, detail: 
		error("fork #2 failed: (%d) %s\n" % (detail.errno, detail.strerror))
		sys.exit(1)
	
	# Redirect standard file descriptors.
	si = file("/dev/null", 'r')
	so = file("/dev/null", 'w')	
	
	os.dup2(si.fileno(), sys.stdin.fileno())
	os.dup2(so.fileno(), sys.stdout.fileno())
	os.dup2(so.fileno(), sys.stderr.fileno())
	
	# If no pidfile to write, all is done
	if not pidfile:
		return
	
	# Open pidfile and write PID value
	try: fd = open(pidfile, "w")
	except OSError: 
		error( "pidfile (%s) creation failed: (%d) %s\n" % (pidfile, detail.errno, detail.strerror))
		sys.exit(1)
			
	fd.write(str(os.getpid())+"\n")
	fd.close()
