#!/usr/bin/env python

# tutorials.creating_clients.timeuserlistener

#    Copyright (c) 2005 Simon Yuill.
#
#    This file is part of 'Social Versioning System' (SVS).
#
#    'Social Versioning System' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'Social Versioning System' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'Social Versioning System'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA


"""
'Creating Clients' tutorial source code.

GUI time user client with listener system.

@author:	Simon Yuill
@copyright:	Simon Yuill
@license:	GNU GPL version 2 or any later version
@contact:	simon@lipparosa.org
"""

# svs imports
from svs_core.network.clientuser import GUIClient
from svs_core.gui.clientgui import ClientGUI
from timeusergui import GraphicTimeUser

#############################
# CLIENT
#############################
class TimeUserListener(GraphicTimeUser):
	"""
	Client accessing time service.
	"""
	def __init__(self, name, passwd):
		GraphicTimeUser.__init__(self, name, passwd)

	#######################
	# NETWORK
	#######################
	def haveJoinedClusterGroup(self):
		"""
		Automatically called after client has joined a cluster group.
		"""
		GraphicTimeUser.haveJoinedClusterGroup(self)
		self.startListeningTo(self.timeService, listenFor='time_log')





#########################
# MAIN
#########################
if __name__ == '__main__':
	import sys
	timeuser = TimeUserListener(sys.argv[1], sys.argv[2])
	timeuser.timeService = 'time_service'
	timeuser.connect("time_group", "localhost", 9797)
