/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.language.markup.xsp;

import org.apache.cocoon.util.location.LocatedException;
import org.apache.cocoon.util.location.LocationUtils;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class XSPExpressionParser {
    protected static final State TEXT_STATE = new State(){

        public void consume(XSPExpressionParser parser, char ch) throws SAXException {
            switch (ch) {
                case '{': {
                    parser.setState(LBRACE_STATE);
                    break;
                }
                default: {
                    parser.append(ch);
                }
            }
        }

        public void done(XSPExpressionParser parser) throws SAXException {
            parser.handleText();
        }
    };
    protected static final State LBRACE_STATE = new State(){

        public void consume(XSPExpressionParser parser, char ch) throws SAXException {
            switch (ch) {
                case '#': {
                    parser.setState(TEXT_HASH_STATE);
                    break;
                }
                default: {
                    parser.append('{');
                    parser.append(ch);
                    parser.setState(TEXT_STATE);
                }
            }
        }

        public void done(XSPExpressionParser parser) throws SAXException {
            parser.append('{');
            parser.handleText();
        }
    };
    protected static final State TEXT_HASH_STATE = new State(){

        public void consume(XSPExpressionParser parser, char ch) throws SAXException {
            switch (ch) {
                case '#': {
                    parser.append('{');
                    parser.append('#');
                    parser.setState(TEXT_STATE);
                    break;
                }
                default: {
                    parser.handleText();
                    parser.initExpression();
                    parser.setState(EXPRESSION_STATE);
                    EXPRESSION_STATE.consume(parser, ch);
                }
            }
        }
    };
    protected static final State EXPRESSION_STATE = new State(){

        public void consume(XSPExpressionParser parser, char ch) throws SAXException {
            switch (ch) {
                case '{': {
                    parser.incrNesting();
                    parser.append(ch);
                    break;
                }
                case '}': {
                    if (parser.decrNesting() > 0) {
                        parser.append(ch);
                        break;
                    }
                    parser.handleExpression();
                    parser.setState(TEXT_STATE);
                    break;
                }
                case '\"': {
                    parser.append(ch);
                    parser.setState(EXPRESSION_STRING_STATE);
                    break;
                }
                case '\'': {
                    parser.append(ch);
                    parser.setState(EXPRESSION_CHAR_STATE);
                    break;
                }
                case '\u00b4': {
                    parser.append(ch);
                    parser.setState(EXPRESSION_SHELL_STATE);
                    break;
                }
                default: {
                    parser.append(ch);
                }
            }
        }
    };
    protected static final State EXPRESSION_STRING_STATE = new QuotedState('\"');
    protected static final State EXPRESSION_CHAR_STATE = new QuotedState('\'');
    protected static final State EXPRESSION_SHELL_STATE = new QuotedState('`');
    private State state = TEXT_STATE;
    private int nesting = 0;
    private boolean escaped = false;
    private Handler handler;
    private char[] buf = new char[256];
    private int bufSize;
    private int bufGrow = 256;

    public XSPExpressionParser(Handler handler) {
        this.handler = handler;
    }

    public void consume(String chars) throws SAXException {
        int end = chars.length();
        for (int i = 0; i < end; ++i) {
            char ch = chars.charAt(i);
            this.state.consume(this, ch);
        }
    }

    public void consume(char[] chars, int start, int length) throws SAXException {
        int end = start + length;
        for (int i = start; i < end; ++i) {
            char ch = chars[i];
            this.state.consume(this, ch);
        }
    }

    public void flush(Locator locator, String description) throws SAXException {
        try {
            this.state.done(this);
            this.bufSize = 0;
            this.state = TEXT_STATE;
        }
        catch (SAXException ex) {
            throw new SAXException((Exception)new LocatedException(ex.getMessage(), (Throwable)ex, LocationUtils.getLocation((Object)locator, (String)description)));
        }
    }

    protected State getState() {
        return this.state;
    }

    protected void setState(State state) {
        this.state = state;
    }

    protected void initExpression() {
        this.nesting = 1;
        this.escaped = false;
    }

    protected void incrNesting() {
        ++this.nesting;
    }

    protected int decrNesting() {
        return --this.nesting;
    }

    protected void setEscaped(boolean escaped) {
        this.escaped = escaped;
    }

    protected boolean isEscaped() {
        return this.escaped;
    }

    protected String getExpression() {
        return new String(this.buf, 0, this.bufSize);
    }

    protected void handleText() throws SAXException {
        if (this.bufSize > 0) {
            this.handler.handleText(this.buf, 0, this.bufSize);
            this.bufSize = 0;
        }
    }

    protected void handleExpression() throws SAXException {
        if (this.bufSize == 0) {
            throw new SAXException("Illegal empty expression.");
        }
        this.handler.handleExpression(this.buf, 0, this.bufSize);
        this.bufSize = 0;
    }

    protected void append(char ch) {
        if (this.bufSize + 1 >= this.buf.length) {
            char[] newBuf = new char[this.buf.length + this.bufGrow];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
        this.buf[this.bufSize] = ch;
        ++this.bufSize;
    }

    protected static class QuotedState
    extends State {
        private final char quote;

        public QuotedState(char quote) {
            this.quote = quote;
        }

        public void consume(XSPExpressionParser parser, char ch) throws SAXException {
            parser.append(ch);
            if (ch == this.quote && !parser.isEscaped()) {
                parser.setState(EXPRESSION_STATE);
            } else if (ch == '\\') {
                parser.setEscaped(!parser.isEscaped());
            } else {
                parser.setEscaped(false);
            }
        }
    }

    protected static abstract class State {
        protected State() {
        }

        public abstract void consume(XSPExpressionParser var1, char var2) throws SAXException;

        public void done(XSPExpressionParser parser) throws SAXException {
            throw new SAXException("Incomplete XSP expression {#" + parser.getExpression());
        }
    }

    public static interface Handler {
        public void handleText(char[] var1, int var2, int var3) throws SAXException;

        public void handleExpression(char[] var1, int var2, int var3) throws SAXException;
    }
}

