/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.acting.AbstractDatabaseAction;
import org.apache.cocoon.components.language.markup.xsp.XSPCookieHelper;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.Session;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;

public class DatabaseCookieAuthenticatorAction
extends AbstractDatabaseAction
implements ThreadSafe {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws Exception {
        DataSourceComponent datasource = null;
        Connection conn = null;
        Statement st = null;
        ResultSet rs = null;
        boolean reloadable = true;
        if (this.settings.containsKey((Object)"reloadable")) {
            reloadable = Boolean.valueOf((String)this.settings.get((Object)"reloadable"));
        }
        try {
            Request req;
            block48: {
                Session session;
                Configuration conf;
                block47: {
                    block49: {
                        boolean as;
                        block51: {
                            block50: {
                                conf = this.getConfiguration(parameters.getParameter("descriptor", (String)this.settings.get((Object)"descriptor")), resolver, parameters.getParameterAsBoolean("reloadable", reloadable));
                                String create_session = parameters.getParameter("create-session", (String)this.settings.get((Object)"create-session"));
                                String append_session = parameters.getParameter("append-session", (String)this.settings.get((Object)"append-session"));
                                boolean cs = true;
                                if (create_session != null) {
                                    cs = BooleanUtils.toBoolean((String)create_session.trim());
                                }
                                as = BooleanUtils.toBoolean((String)append_session.trim());
                                datasource = this.getDataSource(conf);
                                conn = datasource.getConnection();
                                req = ObjectModelHelper.getRequest((Map)objectModel);
                                if (req == null) {
                                    if (this.getLogger().isDebugEnabled()) {
                                        this.getLogger().debug("DBCOOKIEAUTH: no request object");
                                    }
                                    Map map = null;
                                    return map;
                                }
                                String query = this.getAuthQuery(objectModel, conf, req);
                                if (query == null) {
                                    if (this.getLogger().isDebugEnabled()) {
                                        this.getLogger().debug("DBCOOKIEAUTH: have not got query");
                                    }
                                    req.setAttribute("message", (Object)"The authenticator is misconfigured");
                                    Map e = null;
                                    return e;
                                }
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("DBCOOKIEAUTH: query is: " + query);
                                }
                                if (!(rs = (st = conn.createStatement()).executeQuery(query)).next()) break block48;
                                if (this.getLogger().isDebugEnabled()) {
                                    this.getLogger().debug("DBCOOKIEAUTH: authorized successfully");
                                }
                                session = null;
                                if (!cs) break block49;
                                session = req.getSession(false);
                                if (session == null) break block50;
                                if (!as) {
                                    session.invalidate();
                                    session = req.getSession(true);
                                    if (this.getLogger().isDebugEnabled()) {
                                        this.getLogger().debug("DBCOOKIEAUTH: session invalidated");
                                    }
                                }
                                break block51;
                            }
                            session = req.getSession(true);
                        }
                        if (session == null) {
                            Map e = null;
                            return e;
                        }
                        if (this.getLogger().isDebugEnabled()) {
                            if (as) {
                                this.getLogger().debug("DBCOOKIEAUTH: appending to session");
                                break block47;
                            } else {
                                this.getLogger().debug("DBCOOKIEAUTH: session created");
                            }
                        }
                        break block47;
                    }
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("DBCOOKIEAUTH: leaving session untouched");
                    }
                }
                HashMap actionMap = this.propagateParameters(conf, rs, session);
                if (!conn.getAutoCommit()) {
                    conn.commit();
                }
                Map map = Collections.unmodifiableMap(actionMap);
                return map;
            }
            if (!conn.getAutoCommit()) {
                conn.rollback();
            }
            req.setAttribute("message", (Object)"The username or password were incorrect, please check your CAPS LOCK key and try again.");
            if (!this.getLogger().isDebugEnabled()) return null;
            this.getLogger().debug("DBCOOKIEAUTH: no results for query");
            return null;
        }
        catch (Exception e) {
            if (conn != null) {
                try {
                    if (!conn.getAutoCommit()) {
                        conn.rollback();
                    }
                }
                catch (Exception se) {
                    // empty catch block
                }
            }
            this.getLogger().error("Exception: ", (Throwable)e);
            Map map = null;
            return map;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception e) {}
            }
        }
    }

    private String getAuthQuery(Map objectModel, Configuration conf, Request req) {
        boolean first_constraint = true;
        StringBuffer queryBuffer = new StringBuffer("SELECT ");
        StringBuffer queryBufferEnd = new StringBuffer("");
        boolean nullable = false;
        Configuration table = conf.getChild("table");
        Configuration[] select = table.getChildren("select");
        try {
            int i = 0;
            while (i < select.length) {
                if (i != 0) {
                    queryBuffer.append(", ");
                }
                String dbcol = select[i].getAttribute("dbcol");
                queryBuffer.append(dbcol);
                String cookie_name = select[i].getAttribute("cookie-name", "");
                if (!StringUtils.isEmpty((String)cookie_name.trim())) {
                    String cookie_value;
                    String nullstr = select[i].getAttribute("nullable", "");
                    if (BooleanUtils.toBoolean((String)nullstr.trim())) {
                        nullable = true;
                    }
                    if ((cookie_value = XSPCookieHelper.getCookie((Map)objectModel, (String)cookie_name, (int)-1).getValue()) == null || cookie_value.trim().equals("")) {
                        if (!nullable) {
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("DBCOOKIEAUTH: cookie-name " + cookie_name + " does not exist");
                            }
                            return null;
                        }
                    } else {
                        if (!first_constraint) {
                            queryBufferEnd.append(" AND ");
                        }
                        queryBufferEnd.append(dbcol + "='" + cookie_value + "'");
                        first_constraint = false;
                    }
                }
                ++i;
            }
            queryBuffer.append(" FROM ");
            queryBuffer.append(table.getAttribute("name"));
            if (!queryBufferEnd.toString().trim().equals("")) {
                queryBuffer.append(" WHERE ").append(queryBufferEnd);
            }
            return queryBuffer.toString();
        }
        catch (Exception e) {
            this.getLogger().error("Exception: ", (Throwable)e);
            return null;
        }
    }

    private HashMap propagateParameters(Configuration conf, ResultSet rs, Session session) {
        Configuration table = conf.getChild("table");
        Configuration[] select = table.getChildren("select");
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            int i = 0;
            while (i < select.length) {
                try {
                    String session_param = select[i].getAttribute("to-session");
                    if (session_param != null && !session_param.trim().equals("")) {
                        String s = rs.getString(i + 1);
                        Object o = null;
                        String type = select[i].getAttribute("type", "");
                        if (StringUtils.isEmpty((String)type.trim()) || "string".equals(type)) {
                            o = s;
                        } else if ("long".equals(type)) {
                            Long l = Long.decode(s);
                            o = l;
                        } else if ("double".equals(type)) {
                            Double d = Double.valueOf(s);
                            o = d;
                        }
                        if (session != null) {
                            session.setAttribute(session_param, o);
                            if (this.getLogger().isDebugEnabled()) {
                                this.getLogger().debug("DBCOOKIEAUTH: propagating param " + session_param + "=" + s);
                            }
                        }
                        map.put(session_param, (String)o);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                ++i;
            }
            return map;
        }
        catch (Exception e) {
            this.getLogger().error("Exception: ", (Throwable)e);
            return null;
        }
    }
}

