/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.variables;

import org.apache.cocoon.sitemap.PatternException;

public final class VariableExpressionTokenizer {
    public static void tokenize(String expression, TokenReciever reciever) throws PatternException {
        int i;
        int lastTokenType = 0;
        int openCount = 0;
        int closeCount = 0;
        int pos = 0;
        boolean escape = false;
        for (i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (escape) {
                escape = false;
                continue;
            }
            if (c == '\\' && i < expression.length()) {
                char nextChar = expression.charAt(i + 1);
                if (nextChar != '{' && nextChar != '}') continue;
                expression = expression.substring(0, i) + expression.substring(i + 1);
                escape = true;
                --i;
                continue;
            }
            if (c == '{') {
                if (i > pos) {
                    lastTokenType = -5;
                    reciever.addToken(-5, expression.substring(pos, i));
                }
                ++openCount;
                lastTokenType = -2;
                reciever.addToken(-2, null);
                int colonPos = VariableExpressionTokenizer.indexOf(expression, ':', i);
                int closePos = VariableExpressionTokenizer.indexOf(expression, '}', i);
                int openPos = VariableExpressionTokenizer.indexOf(expression, '{', i);
                if (openPos < colonPos && openPos < closePos) {
                    throw new PatternException("Invalid '{' at position " + i + " in expression \"" + expression + "\"");
                }
                if (colonPos < closePos) {
                    String module = expression.substring(i + 1, colonPos);
                    lastTokenType = -6;
                    reciever.addToken(-6, module);
                    i = colonPos - 1;
                } else {
                    lastTokenType = -8;
                    reciever.addToken(-8, expression.substring(i + 1, closePos));
                    i = closePos - 1;
                }
                pos = i + 1;
                continue;
            }
            if (c == '}') {
                if (i > 0 && expression.charAt(i - 1) == '\\') continue;
                if (i > pos) {
                    lastTokenType = -5;
                    reciever.addToken(-5, expression.substring(pos, i));
                }
                ++closeCount;
                lastTokenType = -3;
                reciever.addToken(-3, null);
                pos = i + 1;
                continue;
            }
            if (c != ':' || lastTokenType != -6 || i != pos) continue;
            lastTokenType = -4;
            reciever.addToken(-4, null);
            pos = i + 1;
        }
        if (i > pos) {
            lastTokenType = -5;
            reciever.addToken(-5, expression.substring(pos, i));
        }
        if (openCount != closeCount) {
            throw new PatternException("Mismatching braces in expression \"" + expression + "\"");
        }
    }

    private static int indexOf(String expression, char chr, int pos) {
        int location = expression.indexOf(chr, pos + 1);
        return location != -1 ? location : expression.length();
    }

    public static interface TokenReciever {
        public static final int OPEN = -2;
        public static final int CLOSE = -3;
        public static final int COLON = -4;
        public static final int TEXT = -5;
        public static final int MODULE = -6;
        public static final int VARIABLE = -8;

        public void addToken(int var1, String var2) throws PatternException;
    }
}

