/*
 * Decompiled with CFR 0.152.
 */
package org.tempuri.javacImpl.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.tempuri.javac.JavaClassReader;
import org.tempuri.javac.JavaClassWriter;
import org.tempuri.javac.JavaSourceReader;
import org.tempuri.javac.util.MemoryClassFactory;

public class MemoryClassFactoryImpl
implements MemoryClassFactory {
    Map sourceMap;
    Map outputMap = Collections.synchronizedMap(new TreeMap());
    DefiningClassLoader definingClassLoader = new DefiningClassLoader(ClassLoader.getSystemClassLoader());

    public void setInput(Map sourceMap) {
        this.sourceMap = sourceMap;
        this.definingClassLoader = new DefiningClassLoader(this.definingClassLoader.getParent());
        this.outputMap = Collections.synchronizedMap(new TreeMap());
    }

    public Map getOutput() {
        return this.outputMap;
    }

    public JavaSourceReader getSourceReader(String className) throws IOException {
        Map map = this.sourceMap;
        if (map == null) {
            return null;
        }
        Object obj = map.get(className);
        if (obj == null) {
            return null;
        }
        return new SourceReaderImpl(className, obj.toString());
    }

    public JavaClassReader getClassReader(String className) throws IOException {
        String resourceName = className.replace('.', '/') + ".class";
        InputStream strm = this.definingClassLoader.getResourceAsStream(resourceName);
        if (strm == null) {
            return null;
        }
        return new ClassReaderImpl(className, strm);
    }

    public JavaClassWriter getClassWriter(String className) throws IOException {
        return new ClassWriterImpl(className);
    }

    public void setClassLoader(ClassLoader cl) {
        this.definingClassLoader = new DefiningClassLoader(cl);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.definingClassLoader.loadClass(className);
    }

    public class ClassWriterImpl
    implements JavaClassWriter {
        String className;

        ClassWriterImpl(String className) {
            this.className = className;
        }

        public String getClassName() {
            return this.className;
        }

        /*
         * WARNING - void declaration
         */
        public void writeClass(InputStream inputStream) throws IOException {
            int count;
            byte[] buf = new byte[8192];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(buf.length);
            while ((count = inputStream.read(buf, 0, buf.length)) > 0) {
                void var4_4;
                baos.write(buf, 0, (int)var4_4);
            }
            baos.flush();
            byte[] bytes = baos.toByteArray();
            System.out.println("compiled: " + this.className);
            MemoryClassFactoryImpl.this.outputMap.put(this.className, bytes);
        }
    }

    public class ClassReaderImpl
    implements JavaClassReader {
        String className;
        InputStream inputStream;

        public ClassReaderImpl(String className, InputStream stream) {
            this.className = className;
            this.inputStream = stream;
        }

        public String getClassName() {
            return this.className;
        }

        public InputStream getInputStream() throws IOException {
            return this.inputStream;
        }
    }

    public class SourceReaderImpl
    implements JavaSourceReader {
        String className;
        String source;
        Reader reader = null;

        public SourceReaderImpl(String className, String source) {
            this.className = className;
            this.source = source;
        }

        public String getClassName() {
            return this.className;
        }

        public Reader getReader() throws IOException {
            if (this.reader == null) {
                this.reader = new StringReader(this.source);
            }
            return this.reader;
        }
    }

    public class DefiningClassLoader
    extends ClassLoader {
        public DefiningClassLoader(ClassLoader parent) {
            super(parent);
        }

        public Class defineClass(String name, byte[] data) {
            return super.defineClass(name, data, 0, data.length);
        }

        public Class findClass(String className) throws ClassNotFoundException {
            Map map = MemoryClassFactoryImpl.this.outputMap;
            byte[] bytes = (byte[])map.get(className);
            if (bytes != null) {
                return this.defineClass(className, bytes);
            }
            throw new ClassNotFoundException(className);
        }

        public InputStream getResourceAsStream(String name) {
            Map map;
            byte[] bytes;
            String className = null;
            if (name.endsWith(".class") && (bytes = (byte[])(map = MemoryClassFactoryImpl.this.outputMap).get(className = name.substring(0, name.length() - 6).replace('/', '.'))) != null) {
                return new ByteArrayInputStream(bytes);
            }
            return super.getResourceAsStream(name);
        }
    }
}

