/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.datasource.ids;

import java.math.BigDecimal;
import org.apache.avalon.excalibur.datasource.ids.IdException;
import org.apache.avalon.excalibur.datasource.ids.IdGenerator;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.thread.ThreadSafe;

public abstract class AbstractIdGenerator
extends AbstractLogEnabled
implements IdGenerator,
ThreadSafe {
    private static final BigDecimal BIG_DECIMAL_MAX_LONG = new BigDecimal(9.223372036854776E18);
    private Object m_semaphore = new Object();
    private boolean m_useBigDecimals;

    protected abstract BigDecimal getNextBigDecimalIdInner() throws IdException;

    protected abstract long getNextLongIdInner() throws IdException;

    protected final void setUseBigDecimals(boolean useBigDecimals) {
        this.m_useBigDecimals = useBigDecimals;
    }

    protected final boolean isUsingBigDecimals() {
        return this.m_useBigDecimals;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected final long getNextLongIdChecked(long maxId) throws IdException {
        void var3_5;
        long nextId;
        Object bd;
        if (this.m_useBigDecimals) {
            Object object = this.m_semaphore;
            synchronized (object) {
                bd = this.getNextBigDecimalIdInner();
            }
            if (((BigDecimal)bd).compareTo(BIG_DECIMAL_MAX_LONG) > 0) {
                String msg = "Unable to provide an id.  The next id would be greater than the id data type allows.";
                this.getLogger().error(msg);
                throw new IdException(msg);
            }
            nextId = ((BigDecimal)bd).longValue();
        } else {
            bd = this.m_semaphore;
            synchronized (bd) {
                nextId = this.getNextLongIdInner();
            }
        }
        if (var3_5 > maxId) {
            String msg = "Unable to provide an id.  The next id would be greater than the id data type allows.";
            this.getLogger().error(msg);
            throw new IdException(msg);
        }
        return (long)var3_5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final BigDecimal getNextBigDecimalId() throws IdException {
        void var1_3;
        BigDecimal bd;
        if (this.m_useBigDecimals) {
            Object object = this.m_semaphore;
            synchronized (object) {
                bd = this.getNextBigDecimalIdInner();
            }
        }
        Object object = this.m_semaphore;
        synchronized (object) {
            bd = new BigDecimal((double)this.getNextLongIdInner());
        }
        return var1_3;
    }

    public final long getNextLongId() throws IdException {
        return this.getNextLongIdChecked(Long.MAX_VALUE);
    }

    public final int getNextIntegerId() throws IdException {
        return (int)this.getNextLongIdChecked(Integer.MAX_VALUE);
    }

    public final short getNextShortId() throws IdException {
        return (short)this.getNextLongIdChecked(32767L);
    }

    public final byte getNextByteId() throws IdException {
        return (byte)this.getNextLongIdChecked(127L);
    }
}

