/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.apache.excalibur.instrument.manager.DefaultInstrumentManager;
import org.apache.excalibur.instrument.manager.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.NoSuchInstrumentException;
import org.apache.excalibur.instrument.manager.http.AbstractXMLHandler;
import org.apache.excalibur.instrument.manager.http.InstrumentManagerHTTPConnector;

public class XMLCreateSamplesHandler
extends AbstractXMLHandler {
    private InstrumentManagerHTTPConnector m_connector;

    public XMLCreateSamplesHandler(DefaultInstrumentManager manager, InstrumentManagerHTTPConnector connector) {
        super("/create-samples.xml", manager);
        this.m_connector = connector;
    }

    public void doGet(String path, Map parameters, PrintWriter out) throws IOException {
        String[] names = this.getParameters(parameters, "name");
        String[] descriptions = this.getParameters(parameters, "description");
        long[] intervals = this.getLongParameters(parameters, "interval", 0L);
        int[] sizes = this.getIntegerParameters(parameters, "size", 0);
        long[] leases = this.getLongParameters(parameters, "lease", 0L);
        int[] types = this.getIntegerParameters(parameters, "type", 0);
        boolean packed = this.getBooleanParameter(parameters, "packed", false);
        if (names.length != descriptions.length) {
            throw new FileNotFoundException("The number of descriptions not equal to the number of names.");
        }
        if (names.length != intervals.length) {
            throw new FileNotFoundException("The number of intervals not equal to the number of names.");
        }
        if (names.length != sizes.length) {
            throw new FileNotFoundException("The number of sizes not equal to the number of names.");
        }
        if (names.length != leases.length) {
            throw new FileNotFoundException("The number of leases not equal to the number of names.");
        }
        if (names.length != types.length) {
            throw new FileNotFoundException("The number of types not equal to the number of names.");
        }
        out.println("<?xml version='1.0' encoding='UTF-8'?>");
        if (names.length > 0) {
            this.outputLine(out, "", packed, "<samples>");
            for (int i = 0; i < names.length; ++i) {
                InstrumentSampleDescriptor sample;
                InstrumentDescriptor desc;
                String name = names[i];
                String description = descriptions[i];
                long interval = intervals[i];
                int size = sizes[i];
                long lease = leases[i];
                int type = types[i];
                try {
                    desc = this.getInstrumentManager().locateInstrumentDescriptor(name);
                }
                catch (NoSuchInstrumentException e) {
                    desc = null;
                }
                if (desc == null) continue;
                size = Math.max(1, Math.min(size, this.m_connector.getMaxLeasedSampleSize()));
                lease = Math.max(1L, Math.min(lease, this.m_connector.getMaxLeasedSampleLease()));
                if (this.getInstrumentManager().getLeaseSampleCount() >= this.m_connector.getMaxLeasedSamples()) {
                    lease = 1L;
                }
                try {
                    sample = desc.createInstrumentSample(description, interval, size, lease, type);
                }
                catch (IllegalArgumentException e) {
                    throw new FileNotFoundException(e.getMessage());
                }
                catch (IllegalStateException e) {
                    throw new FileNotFoundException(e.getMessage());
                }
                this.outputSample(out, sample, "  ", packed);
            }
            this.outputLine(out, "", packed, "</samples>");
        } else {
            this.outputLine(out, "", packed, "<samples/>");
        }
    }
}

