/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.om;

import net.sf.saxon.Configuration;
import net.sf.saxon.Err;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.FastStringBuffer;
import net.sf.saxon.om.FingerprintedNode;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.Navigator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SingleNodeIterator;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.value.Value;

public final class Orphan
implements NodeInfo,
FingerprintedNode {
    private short kind;
    private int nameCode = -1;
    private CharSequence stringValue;
    private int typeAnnotation = -1;
    private Configuration config;
    private String systemId;

    public Orphan(Configuration configuration) {
        this.config = configuration;
    }

    public void setNodeKind(short s) {
        this.kind = s;
    }

    public void setNameCode(int n) {
        this.nameCode = n;
    }

    public void setStringValue(CharSequence charSequence) {
        this.stringValue = charSequence;
    }

    public void setTypeAnnotation(int n) {
        this.typeAnnotation = n;
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public int getNodeKind() {
        return this.kind;
    }

    public SequenceIterator getTypedValue() throws XPathException {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return SingletonIterator.makeIterator(new StringValue(this.stringValue));
            }
            case 3: 
            case 9: 
            case 13: {
                return SingletonIterator.makeIterator(new UntypedAtomicValue(this.stringValue));
            }
        }
        if (this.typeAnnotation == -1 || this.typeAnnotation == 630 || this.typeAnnotation == 631) {
            return SingletonIterator.makeIterator(new UntypedAtomicValue(this.stringValue));
        }
        SchemaType schemaType = this.config.getSchemaType(this.typeAnnotation);
        if (schemaType == null) {
            String string = this.config.getNamePool().getDisplayName(this.typeAnnotation);
            throw new IllegalStateException("Unknown type annotation " + Err.wrap(string) + " in standalone node");
        }
        return schemaType.getTypedValue(this);
    }

    public Value atomize() throws XPathException {
        switch (this.getNodeKind()) {
            case 7: 
            case 8: {
                return new StringValue(this.stringValue);
            }
            case 3: 
            case 9: 
            case 13: {
                return new UntypedAtomicValue(this.stringValue);
            }
        }
        if (this.typeAnnotation == -1 || this.typeAnnotation == 630 || this.typeAnnotation == 631) {
            return new UntypedAtomicValue(this.stringValue);
        }
        SchemaType schemaType = this.config.getSchemaType(this.typeAnnotation);
        if (schemaType == null) {
            String string = this.config.getNamePool().getDisplayName(this.typeAnnotation);
            throw new IllegalStateException("Unknown type annotation " + Err.wrap(string) + " in standalone node");
        }
        return schemaType.atomize(this);
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    public int getTypeAnnotation() {
        if (this.typeAnnotation == -1) {
            if (this.kind == 1) {
                return 630;
            }
            if (this.kind == 2) {
                return 631;
            }
        }
        return this.typeAnnotation;
    }

    public boolean isSameNodeInfo(NodeInfo nodeInfo) {
        return this == nodeInfo;
    }

    public boolean equals(Object object) {
        if (object instanceof NodeInfo) {
            return this.isSameNodeInfo((NodeInfo)object);
        }
        return false;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getBaseURI() {
        if (this.kind == 7) {
            return this.systemId;
        }
        return null;
    }

    public int getLineNumber() {
        return -1;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        if (this.isSameNodeInfo(nodeInfo)) {
            return 0;
        }
        return this.hashCode() < ((Object)nodeInfo).hashCode() ? -1 : 1;
    }

    public String getStringValue() {
        return ((Object)this.stringValue).toString();
    }

    public CharSequence getStringValueCS() {
        return this.stringValue;
    }

    public int getNameCode() {
        return this.nameCode;
    }

    public int getFingerprint() {
        if (this.nameCode == -1) {
            return -1;
        }
        return this.getNameCode() & 0xFFFFF;
    }

    public String getLocalPart() {
        if (this.nameCode == -1) {
            return "";
        }
        return this.config.getNamePool().getLocalName(this.nameCode);
    }

    public String getURI() {
        if (this.nameCode == -1) {
            return "";
        }
        return this.config.getNamePool().getURI(this.nameCode);
    }

    public String getPrefix() {
        if (this.nameCode == -1) {
            return "";
        }
        return this.config.getNamePool().getPrefix(this.nameCode);
    }

    public String getDisplayName() {
        if (this.nameCode == -1) {
            return "";
        }
        return this.config.getNamePool().getDisplayName(this.nameCode);
    }

    public NodeInfo getParent() {
        return null;
    }

    public AxisIterator iterateAxis(byte by) {
        switch (by) {
            case 1: 
            case 5: 
            case 12: {
                return SingleNodeIterator.makeIterator(this);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.getInstance();
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (by) {
            case 1: 
            case 5: 
            case 12: {
                return Navigator.filteredSingleton(this, nodeTest);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.getInstance();
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public String getAttributeValue(int n) {
        return null;
    }

    public NodeInfo getRoot() {
        return this;
    }

    public DocumentInfo getDocumentRoot() {
        return null;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public void generateId(FastStringBuffer fastStringBuffer) {
        fastStringBuffer.append('Q');
        fastStringBuffer.append(Integer.toString(this.hashCode()));
    }

    public int getDocumentNumber() {
        return this.hashCode() & 0xFFFFFF;
    }

    public void copy(Receiver receiver, int n, boolean bl, int n2) throws XPathException {
        Navigator.copy(this, receiver, this.config.getNamePool(), n, bl, n2);
    }

    public void sendNamespaceDeclarations(Receiver receiver, boolean bl) {
    }

    public int[] getDeclaredNamespaces(int[] nArray) {
        return null;
    }
}

