/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.components.source.impl.ContextSourceFactory;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceResolver;
import org.apache.excalibur.source.impl.ResourceSourceFactory;
import org.apache.excalibur.source.impl.URLSourceFactory;

public final class SimpleSourceResolver
extends AbstractLogEnabled
implements ThreadSafe,
Contextualizable,
SourceResolver {
    private String contextBase;
    private ResourceSourceFactory resourceFactory = new ResourceSourceFactory();
    private URLSourceFactory urlFactory = new URLSourceFactory();
    private ContextSourceFactory contextFactory = new ContextSourceFactory();

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.resourceFactory.enableLogging(logger);
        this.urlFactory.enableLogging(logger);
        this.contextFactory.enableLogging(logger);
    }

    public void contextualize(Context context) throws ContextException {
        this.contextFactory.contextualize(context);
        try {
            this.contextFactory.service(new SimpleServiceManager(this));
        }
        catch (ServiceException se) {
            throw new ContextException("Unable to service context factory.", (Throwable)se);
        }
        try {
            this.contextBase = context.get((Object)"context-root") instanceof URL ? ((URL)context.get((Object)"context-root")).toExternalForm() : ((File)context.get((Object)"context-root")).toURL().toExternalForm();
        }
        catch (ContextException ce) {
            try {
                this.contextBase = new File(System.getProperty("user.dir")).toURL().toExternalForm();
            }
            catch (MalformedURLException mue) {
                throw new ContextException("Malformed URL for user.dir, and no context-root exists", (Throwable)mue);
            }
        }
        catch (MalformedURLException mue) {
            throw new ContextException("Malformed URL for context-root", (Throwable)mue);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Base URL set to " + this.contextBase);
        }
    }

    public Source resolveURI(String uri) throws MalformedURLException, IOException {
        return this.resolveURI(uri, this.contextBase, null);
    }

    public Source resolveURI(String uri, String base, Map params) throws MalformedURLException, IOException {
        URL url;
        if (uri.startsWith("resource://")) {
            return this.resourceFactory.getSource(uri, null);
        }
        if (uri.startsWith("context://")) {
            return this.contextFactory.getSource(uri, params);
        }
        if (uri.length() > 1 && uri.charAt(1) == ':') {
            uri = "file:/" + uri;
            base = null;
        } else if (uri.length() > 2 && uri.charAt(0) == '/' && uri.charAt(2) == ':') {
            uri = "file:" + uri;
            base = null;
        }
        if (base == null) {
            url = new URL(uri);
        } else {
            URL baseURL = new URL(base);
            url = new URL(baseURL, uri);
        }
        return this.urlFactory.getSource(url.toExternalForm(), params);
    }

    public void release(Source source) {
        if (source != null) {
            if ("context".equals(source.getScheme())) {
                this.contextFactory.release(source);
            } else if ("resource".equals(source.getScheme())) {
                this.resourceFactory.release(source);
            } else {
                this.urlFactory.release(source);
            }
        }
    }

    public static final class SimpleServiceManager
    implements ServiceManager {
        private final SourceResolver resolver;

        public SimpleServiceManager(SourceResolver resolver) {
            this.resolver = resolver;
        }

        public boolean hasService(String role) {
            return SourceResolver.ROLE.equals(role);
        }

        public Object lookup(String role) throws ServiceException {
            if (!SourceResolver.ROLE.equals(role)) {
                throw new ServiceException("SimpleServiceManager", "Unable to lookup component with role: " + role);
            }
            return this.resolver;
        }

        public void release(Object component) {
        }
    }
}

