/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.transformation;

import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.apache.avalon.framework.CascadingRuntimeException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.WrapperComponentManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.Processor;
import org.apache.cocoon.caching.CacheableProcessingComponent;
import org.apache.cocoon.components.CocoonComponentManager;
import org.apache.cocoon.components.source.SourceUtil;
import org.apache.cocoon.components.source.impl.MultiSourceValidity;
import org.apache.cocoon.components.thread.RunnableManager;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.transformation.AbstractTransformer;
import org.apache.cocoon.transformation.helpers.NOPRecorder;
import org.apache.cocoon.util.NetUtils;
import org.apache.cocoon.xml.AbstractXMLPipe;
import org.apache.cocoon.xml.IncludeXMLConsumer;
import org.apache.cocoon.xml.NamespacesTable;
import org.apache.cocoon.xml.SaxBuffer;
import org.apache.cocoon.xml.XMLConsumer;
import org.apache.excalibur.source.Source;
import org.apache.excalibur.source.SourceValidity;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class IncludeTransformer
extends AbstractTransformer
implements Serviceable,
Configurable,
CacheableProcessingComponent {
    private static final String NS_URI = "http://apache.org/cocoon/include/1.0";
    private static final String INCLUDE_ELEMENT = "include";
    private static final String FALLBACK_ELEMENT = "fallback";
    private static final String PARAMETER_ELEMENT = "parameter";
    private static final String SRC_ATTRIBUTE = "src";
    private static final String MIME_ATTRIBUTE = "mime-type";
    private static final String PARSE_ATTRIBUTE = "parse";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String ENCODING = "US-ASCII";
    protected ServiceManager manager;
    private boolean defaultRecursive;
    private boolean defaultParallel;
    private boolean defaultRecursiveParallel;
    protected String threadPool;
    private String defaultKey;
    protected SourceResolver resolver;
    protected Environment environment;
    private Processor processor;
    private String key;
    protected MultiSourceValidity validity;
    private NamespacesTable namespaces;
    private final IncludeXMLPipe pipe = new IncludeXMLPipe();

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.pipe.enableLogging(logger);
    }

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.defaultRecursive = configuration.getChild("recursive").getValueAsBoolean(false);
        this.defaultParallel = configuration.getChild("parallel").getValueAsBoolean(false);
        this.defaultRecursiveParallel = configuration.getChild("recursive-parallel").getValueAsBoolean(false);
        this.threadPool = configuration.getChild("thread-pool").getValue("default");
        this.defaultKey = configuration.getChild("key").getValue(null);
    }

    public void setup(SourceResolver resolver, Map om, String src, Parameters parameters) throws ProcessingException, SAXException, IOException {
        this.pipe.recursive = parameters.getParameterAsBoolean("recursive", this.defaultRecursive);
        this.pipe.parallel = parameters.getParameterAsBoolean("parallel", this.defaultParallel);
        this.pipe.recursiveParallel = parameters.getParameterAsBoolean("recursive-parallel", this.defaultRecursiveParallel);
        this.key = parameters.getParameter("key", this.defaultKey);
        if (this.pipe.parallel) {
            this.environment = CocoonComponentManager.getCurrentEnvironment();
            this.processor = CocoonComponentManager.getCurrentProcessor();
        }
        this.namespaces = new NamespacesTable();
        this.resolver = resolver;
        this.validity = null;
        this.xmlConsumer = this.pipe;
        this.contentHandler = this.pipe;
        this.lexicalHandler = this.pipe;
    }

    public void setConsumer(XMLConsumer consumer) {
        this.pipe.setConsumer(consumer);
    }

    public void setContentHandler(ContentHandler handler) {
        this.pipe.setContentHandler(handler);
    }

    public void setLexicalHandler(LexicalHandler handler) {
        this.pipe.setLexicalHandler(handler);
    }

    public void recycle() {
        this.namespaces = null;
        this.validity = null;
        this.pipe.recycle();
        this.resolver = null;
        super.recycle();
    }

    public void startDocument() throws SAXException {
        this.getValidity();
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        this.validity.close();
        super.endDocument();
    }

    public void startPrefixMapping(String prefix, String nsuri) throws SAXException {
        if (NS_URI.equals(nsuri)) {
            this.namespaces.addDeclaration(prefix, nsuri);
        } else {
            super.startPrefixMapping(prefix, nsuri);
        }
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        if (NS_URI.equals(this.namespaces.getUri(prefix))) {
            this.namespaces.removeDeclaration(prefix);
        } else {
            super.endPrefixMapping(prefix);
        }
    }

    public Serializable getKey() {
        return this.key == null ? "I" : "I" + this.key;
    }

    public SourceValidity getValidity() {
        if (this.validity == null) {
            this.validity = new MultiSourceValidity(this.resolver, -1L);
        }
        return this.validity;
    }

    private class IncludeXMLPipe
    extends AbstractXMLPipe {
        private final boolean root;
        private boolean recursive;
        private boolean parallel;
        private boolean recursiveParallel;
        private final Stack consumers = new Stack();
        private int depth;
        private String base;
        private IncludeElement element;
        private boolean buffering;
        private SaxBuffer buffer;
        private int threads;

        public IncludeXMLPipe() {
            this.root = true;
        }

        public IncludeXMLPipe(Logger logger, ContentHandler contentHandler, LexicalHandler lexicalHandler, boolean recursive, boolean parallel, boolean recursiveParallel) {
            this.root = false;
            this.enableLogging(logger);
            this.setContentHandler(contentHandler);
            this.setLexicalHandler(lexicalHandler);
            this.recursive = recursive;
            this.parallel = parallel;
            this.recursiveParallel = recursiveParallel;
        }

        public void recycle() {
            if (this.buffering) {
                this.waitForThreads();
                this.buffering = false;
                this.buffer = null;
            }
            this.threads = 0;
            this.consumers.clear();
            this.base = null;
            this.element = null;
            super.recycle();
        }

        private void push(XMLConsumer consumer) {
            this.consumers.push(new Object[]{this.xmlConsumer, this.contentHandler, this.lexicalHandler});
            this.setConsumer(consumer);
        }

        private void pop() {
            Object[] consumer = (Object[])this.consumers.pop();
            if (consumer[0] != null) {
                this.setConsumer((XMLConsumer)consumer[0]);
            } else {
                this.setContentHandler((ContentHandler)consumer[1]);
                this.setLexicalHandler((LexicalHandler)consumer[2]);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setDocumentLocator(Locator locator) {
            block5: {
                try {
                    if (locator == null || locator.getSystemId() == null) break block5;
                    Source source = IncludeTransformer.this.resolver.resolveURI(locator.getSystemId());
                    try {
                        this.base = source.getURI();
                    }
                    finally {
                        IncludeTransformer.this.resolver.release(source);
                    }
                }
                catch (IOException e) {
                    this.getLogger().warn("Unable to resolve document base URI: <" + locator.getSystemId() + ">");
                }
            }
            super.setDocumentLocator(locator);
        }

        public void startDocument() throws SAXException {
            if (this.root) {
                super.startDocument();
            }
        }

        public void endDocument() throws SAXException {
            if (this.buffering) {
                this.pop();
                this.buffer.toSAX(this.contentHandler);
            }
            if (this.root) {
                super.endDocument();
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (IncludeTransformer.NS_URI.equals(uri)) {
                ++this.depth;
                if (IncludeTransformer.INCLUDE_ELEMENT.equals(localName) && this.depth == 1) {
                    if (this.element != null) {
                        throw new SAXException("Element include nested in another one.");
                    }
                    this.element = new IncludeElement(this.base, this.parallel, this.recursive, this.recursiveParallel, this.getLogger());
                    this.element.source = atts.getValue(IncludeTransformer.SRC_ATTRIBUTE);
                    if (this.element.source == null || this.element.source.length() == 0) {
                        throw new SAXException("Attribute 'src' empty or missing.");
                    }
                    String value = atts.getValue(IncludeTransformer.PARSE_ATTRIBUTE);
                    if (value == null || value.equals("xml")) {
                        this.element.parse = true;
                    } else if (value.equals("text")) {
                        this.element.parse = false;
                    } else {
                        throw new SAXException("Attribute 'parse' has invalid value.");
                    }
                    this.element.mimeType = atts.getValue(IncludeTransformer.MIME_ATTRIBUTE);
                    if (!this.element.parse && this.element.mimeType != null) {
                        throw new SAXException("Attribute 'mime-type' can't be specified for text inclusions.");
                    }
                    if (this.element.mimeType == null) {
                        this.element.mimeType = "text/xml";
                    }
                    this.push(new NOPRecorder(this){
                        private final /* synthetic */ IncludeXMLPipe this$1;
                        {
                            this.this$1 = this$1;
                        }
                    });
                    return;
                }
                if (IncludeTransformer.FALLBACK_ELEMENT.equals(localName) && this.depth == 2) {
                    if (this.element == null) {
                        throw new SAXException("Element fallback specified outside of include.");
                    }
                    if (this.element.fallback != null) {
                        throw new SAXException("Duplicate element fallback.");
                    }
                    this.element.fallback = new SaxBuffer();
                    this.push(this.element.fallback);
                    return;
                }
                if (IncludeTransformer.PARAMETER_ELEMENT.equals(localName) && this.depth == 2) {
                    if (this.element == null) {
                        throw new SAXException("Element parameter specified outside of include.");
                    }
                    if (this.element.parameter != null) {
                        throw new SAXException("Element parameter nested in another one.");
                    }
                    this.element.parameter = atts.getValue(IncludeTransformer.NAME_ATTRIBUTE);
                    if (this.element.parameter == null || this.element.parameter.length() == 0) {
                        throw new SAXException("Attribute 'name' empty or missing.");
                    }
                    String value = atts.getValue(IncludeTransformer.VALUE_ATTRIBUTE);
                    if (value != null) {
                        this.element.value = new StringBuffer(value);
                    }
                    return;
                }
                if (this.depth < 2) {
                    throw new SAXException("Element '" + localName + "' was not expected here.");
                }
            }
            super.startElement(uri, localName, qName, atts);
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (IncludeTransformer.NS_URI.equals(uri)) {
                --this.depth;
                if (IncludeTransformer.INCLUDE_ELEMENT.equals(localName) && this.depth == 0) {
                    this.pop();
                    if (this.element.parameters != null) {
                        this.element.source = NetUtils.parameterize(this.element.source, this.element.parameters);
                        this.element.parameters = null;
                    }
                    if (this.parallel) {
                        if (!this.buffering) {
                            this.buffering = true;
                            this.buffer = new SaxBuffer();
                            this.push(this.buffer);
                        }
                        this.buffer.xmlizable(new IncludeBuffer(this.element));
                    } else {
                        this.element.process(this.contentHandler, this.lexicalHandler);
                    }
                    this.element = null;
                    return;
                }
                if (IncludeTransformer.FALLBACK_ELEMENT.equals(localName) && this.depth == 1) {
                    this.pop();
                    return;
                }
                if (IncludeTransformer.PARAMETER_ELEMENT.equals(localName) && this.depth == 1) {
                    String value = this.element.value != null ? this.element.value.toString() : "";
                    try {
                        if (this.element.parameters == null) {
                            this.element.parameters = new HashMap(5);
                        }
                        this.element.parameters.put(NetUtils.encode(this.element.parameter, IncludeTransformer.ENCODING), NetUtils.encode(value, IncludeTransformer.ENCODING));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SAXException("Your platform does not support the US-ASCII encoding", e);
                    }
                    this.element.value = null;
                    this.element.parameter = null;
                    return;
                }
            }
            super.endElement(uri, localName, qName);
        }

        public void characters(char[] data, int offset, int length) throws SAXException {
            if (this.element != null && this.element.parameter != null) {
                if (this.element.value == null) {
                    this.element.value = new StringBuffer();
                }
                this.element.value.append(data, offset, length);
                return;
            }
            super.characters(data, offset, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int incrementThreads() {
            SaxBuffer saxBuffer = this.buffer;
            synchronized (saxBuffer) {
                return ++this.threads;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void decrementThreads() {
            SaxBuffer saxBuffer = this.buffer;
            synchronized (saxBuffer) {
                if (--this.threads <= 0) {
                    this.buffer.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitForThreads() {
            SaxBuffer saxBuffer = this.buffer;
            synchronized (saxBuffer) {
                if (this.threads > 0) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug(this.threads + " threads in progress, waiting");
                    }
                    try {
                        this.buffer.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }

        private class IncludeBuffer
        extends SaxBuffer
        implements Runnable {
            private IncludeElement element;
            private int thread;
            private boolean finished;
            private SAXException e;

            public IncludeBuffer(IncludeElement element) {
                this.element = element;
                RunnableManager runnable = null;
                try {
                    runnable = (RunnableManager)((IncludeXMLPipe)IncludeXMLPipe.this).IncludeTransformer.this.manager.lookup(RunnableManager.ROLE);
                    runnable.execute(((IncludeXMLPipe)IncludeXMLPipe.this).IncludeTransformer.this.threadPool, this);
                }
                catch (ServiceException e) {
                    throw new CascadingRuntimeException(e.getMessage(), (Throwable)e);
                }
                finally {
                    ((IncludeXMLPipe)IncludeXMLPipe.this).IncludeTransformer.this.manager.release((Object)runnable);
                }
                this.thread = IncludeXMLPipe.this.incrementThreads();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() {
                block17: {
                    IncludeBuffer includeBuffer;
                    try {
                        try {
                            if (IncludeXMLPipe.this.getLogger().isDebugEnabled()) {
                                IncludeXMLPipe.this.getLogger().debug("Thread #" + this.thread + " loading <" + this.element.source + ">");
                            }
                            CocoonComponentManager.enterEnvironment(((IncludeXMLPipe)IncludeXMLPipe.this).IncludeTransformer.this.environment, (ComponentManager)new WrapperComponentManager(((IncludeXMLPipe)IncludeXMLPipe.this).IncludeTransformer.this.manager), IncludeTransformer.this.processor);
                            try {
                                this.element.process(this);
                            }
                            catch (SAXException e) {
                                this.e = e;
                            }
                            finally {
                                CocoonComponentManager.leaveEnvironment();
                            }
                            Object var4_4 = null;
                            includeBuffer = this;
                        }
                        catch (RuntimeException e) {
                            this.e = new SAXException(e);
                            Object var4_5 = null;
                            IncludeBuffer includeBuffer3 = this;
                            synchronized (includeBuffer3) {
                                this.finished = true;
                                this.notify();
                            }
                            IncludeXMLPipe.this.decrementThreads();
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        IncludeBuffer includeBuffer2 = this;
                        synchronized (includeBuffer2) {
                            this.finished = true;
                            this.notify();
                        }
                        IncludeXMLPipe.this.decrementThreads();
                        throw throwable;
                    }
                    synchronized (includeBuffer) {
                        this.finished = true;
                        this.notify();
                    }
                    IncludeXMLPipe.this.decrementThreads();
                }
                if (!IncludeXMLPipe.this.getLogger().isDebugEnabled()) return;
                if (this.e == null) {
                    IncludeXMLPipe.this.getLogger().debug("Thread #" + this.thread + " loaded <" + this.element.source + ">");
                    return;
                }
                IncludeXMLPipe.this.getLogger().debug("Thread #" + this.thread + " failed to load <" + this.element.source + ">", (Throwable)this.e);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void toSAX(ContentHandler contentHandler) throws SAXException {
                IncludeBuffer includeBuffer = this;
                synchronized (includeBuffer) {
                    if (!this.finished) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (this.e != null) {
                    throw this.e;
                }
                super.toSAX(contentHandler);
            }
        }
    }

    private class IncludeElement
    extends AbstractLogEnabled {
        private boolean recursive;
        private boolean parallel;
        private boolean recursiveParallel;
        private String base;
        protected String source;
        protected boolean parse;
        protected String mimeType;
        protected SaxBuffer fallback;
        protected Map parameters;
        protected String parameter;
        protected StringBuffer value;

        private IncludeElement(String base, boolean parallel, boolean recursive, boolean recursiveParallel, Logger logger) {
            this.base = base;
            this.parallel = parallel;
            this.recursive = recursive;
            this.recursiveParallel = recursiveParallel;
            this.enableLogging(logger);
        }

        public void process(SaxBuffer buffer) throws SAXException {
            try {
                this.process0((ContentHandler)((Object)buffer), (LexicalHandler)((Object)buffer));
            }
            catch (SAXException e) {
                buffer.recycle();
                if (this.fallback == null) {
                    throw e;
                }
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("Failed to load <" + this.source + ">, using fallback.", (Throwable)e);
                }
                this.fallback.toSAX((ContentHandler)((Object)new IncludeXMLPipe(this.getLogger(), (ContentHandler)((Object)buffer), (LexicalHandler)((Object)buffer), this.recursive, this.recursiveParallel ? this.parallel : false, this.recursiveParallel)));
            }
        }

        public void process(ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException {
            try {
                if (this.fallback != null) {
                    SaxBuffer buffer = new SaxBuffer();
                    this.process(buffer);
                    buffer.toSAX(contentHandler);
                } else {
                    this.process0(contentHandler, lexicalHandler);
                }
            }
            catch (SAXException e) {
                IncludeTransformer.this.validity = null;
                throw e;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void process0(ContentHandler contentHandler, LexicalHandler lexicalHandler) throws SAXException {
            Source source = null;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Loading <" + this.source + ">");
            }
            try {
                block14: {
                    try {
                        source = this.base != null ? IncludeTransformer.this.resolver.resolveURI(this.source, this.base, null) : IncludeTransformer.this.resolver.resolveURI(this.source);
                        if (IncludeTransformer.this.validity != null) {
                            MultiSourceValidity multiSourceValidity = IncludeTransformer.this.validity;
                            synchronized (multiSourceValidity) {
                                IncludeTransformer.this.validity.addSource(source);
                            }
                        }
                        if (this.parse && this.recursive) {
                            SourceUtil.toSAX(IncludeTransformer.this.manager, source, this.mimeType, (ContentHandler)((Object)new IncludeXMLPipe(this.getLogger(), contentHandler, lexicalHandler, this.recursive, this.recursiveParallel ? this.parallel : false, this.recursiveParallel)));
                        } else if (this.parse) {
                            SourceUtil.toSAX(IncludeTransformer.this.manager, source, this.mimeType, (ContentHandler)((Object)new IncludeXMLConsumer(contentHandler, lexicalHandler)));
                        } else {
                            SourceUtil.toCharacters(source, "utf-8", contentHandler);
                        }
                        if (!this.getLogger().isDebugEnabled()) break block14;
                        this.getLogger().debug("Loaded <" + this.source + ">");
                    }
                    catch (SAXException e) {
                        if (!this.getLogger().isDebugEnabled()) throw e;
                        this.getLogger().debug("Failed to load <" + this.source + ">", (Throwable)e);
                        throw e;
                    }
                    catch (ProcessingException e) {
                        if (!this.getLogger().isDebugEnabled()) throw new SAXException((Exception)((Object)e));
                        this.getLogger().debug("Failed to load <" + this.source + ">", (Throwable)((Object)e));
                        throw new SAXException((Exception)((Object)e));
                    }
                    catch (IOException e) {
                        if (!this.getLogger().isDebugEnabled()) throw new SAXException(e);
                        this.getLogger().debug("Failed to load <" + this.source + ">", (Throwable)e);
                        throw new SAXException(e);
                    }
                }
                Object var7_8 = null;
                if (source == null) return;
                IncludeTransformer.this.resolver.release(source);
                return;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (source == null) throw throwable;
                IncludeTransformer.this.resolver.release(source);
                throw throwable;
            }
        }
    }
}

