/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.AbstractComplementaryConfigurableAction;
import org.apache.cocoon.acting.ValidatorActionHelper;
import org.apache.cocoon.acting.ValidatorActionResult;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.SourceResolver;
import org.apache.cocoon.sitemap.SitemapParameters;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.regexp.RE;
import org.apache.regexp.RESyntaxException;

public abstract class AbstractValidatorAction
extends AbstractComplementaryConfigurableAction {
    protected abstract HashMap createMapOfParameters(Map var1, Collection var2);

    abstract boolean isStringEncoded();

    public Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String src, Parameters parameters) throws Exception {
        Configuration conf = this.getDescriptor(resolver, objectModel, parameters);
        if (conf == null) {
            return null;
        }
        String valStr = parameters.getParameter("validate", (String)this.settings.get("validate", "")).trim();
        String valSetStr = parameters.getParameter("validate-set", (String)this.settings.get("validate-set", "")).trim();
        String constraintSetStr = parameters.getParameter("constraint-set", (String)this.settings.get("constraint-set", "")).trim();
        if (!"".equals(valSetStr)) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info("Using sitemap parameter 'validate-set' for specifying the constraint-set for the ValidatorActions is deprecated in favor of 'constraint-set' due to consistency in the naming.");
            }
            if ("".equals(constraintSetStr)) {
                constraintSetStr = valSetStr;
            }
        }
        Map desc = this.indexConfiguration(conf.getChildren("parameter"));
        HashMap actionMap = new HashMap();
        HashMap resultMap = new HashMap();
        Collection params = null;
        boolean allOK = false;
        if (!"".equals(valStr)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Validating parameters as specified via 'validate' parameter");
            }
            params = this.getSetOfParameterNamesFromSitemap(valStr, desc);
        } else if (!"".equals(constraintSetStr)) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Validating parameters from given constraint-set " + constraintSetStr);
            }
            Map csets = this.indexConfiguration(conf.getChildren("constraint-set"));
            params = this.resolveConstraints(constraintSetStr, csets);
        }
        if (params == null) {
            throw new ProcessingException("Neither a constraint-set nor parameters in the sitemap were specified for validating at " + SitemapParameters.getStatementLocation(parameters));
        }
        HashMap values = this.createMapOfParameters(objectModel, params);
        allOK = this.validateSetOfParameters(desc, actionMap, resultMap, params, values, this.isStringEncoded());
        return this.setResult(objectModel, actionMap, resultMap, allOK);
    }

    public ValidatorActionHelper validateParameter(String name, Configuration constraints, Map conf, Map params, boolean isString) {
        return this.validateParameter(name, name, constraints, conf, params, isString);
    }

    public ValidatorActionHelper validateParameter(String name, String rule, Configuration constraints, Map conf, Map params, boolean isString) {
        String type = null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Validating parameter: " + name + " using rule: " + rule);
        }
        try {
            Configuration theConf = (Configuration)conf.get(rule);
            type = theConf.getAttribute("type");
            return this.validateValue(name, constraints, theConf, params, isString, type);
        }
        catch (Exception e) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("No type specified for parameter " + name);
            }
            return null;
        }
    }

    protected ValidatorActionHelper validateValue(String name, Configuration constraints, Configuration conf, Map params, boolean isString, String type) {
        Object value = params.get(name);
        if (value != null && value.getClass().isArray()) {
            Object[] values = (Object[])value;
            ValidatorActionHelper vaH = null;
            ValidatorActionResult vaR = ValidatorActionResult.OK;
            for (int j = 0; j < values.length; ++j) {
                value = values[j];
                if ("string".equals(type)) {
                    vaH = this.validateString(name, constraints, conf, params, value);
                } else if ("long".equals(type)) {
                    vaH = this.validateLong(name, constraints, conf, params, isString, value);
                } else if ("double".equals(type)) {
                    vaH = this.validateDouble(name, constraints, conf, params, isString, value);
                } else {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Unknown type " + type + " specified for parameter " + name);
                    }
                    return null;
                }
                vaR = vaR.getPos() < vaH.getResult().getPos() ? vaH.getResult() : vaR;
            }
            return new ValidatorActionHelper(vaH.getObject(), vaR);
        }
        if ("string".equals(type)) {
            return this.validateString(name, constraints, conf, params, value);
        }
        if ("long".equals(type)) {
            return this.validateLong(name, constraints, conf, params, isString, value);
        }
        if ("double".equals(type)) {
            return this.validateDouble(name, constraints, conf, params, isString, value);
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Unknown type " + type + " specified for parameter " + name);
        }
        return null;
    }

    private ValidatorActionHelper validateString(String name, Configuration constraints, Configuration conf, Map params, Object param) {
        String value = null;
        String dflt = this.getDefault(conf, constraints);
        boolean nullable = this.getNullable(conf, constraints);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Validating string parameter " + name);
        }
        try {
            value = this.getStringValue(param);
        }
        catch (Exception e) {
            return new ValidatorActionHelper(value, ValidatorActionResult.ERROR);
        }
        if (value == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("String parameter " + name + " is null");
            }
            if (!nullable) {
                return new ValidatorActionHelper(value, ValidatorActionResult.ISNULL);
            }
            return new ValidatorActionHelper(dflt);
        }
        if (constraints != null) {
            String eq = constraints.getAttribute("equals-to", "");
            eq = conf.getAttribute("equals-to", eq);
            String eqp = constraints.getAttribute("equals-to-param", "");
            eqp = conf.getAttribute("equals-to-param", eqp);
            String regex = conf.getAttribute("matches-regex", "");
            regex = constraints.getAttribute("matches-regex", regex);
            String oneOf = conf.getAttribute("one-of", "");
            oneOf = constraints.getAttribute("one-of", oneOf);
            Long minlen = this.getAttributeAsLong(conf, "min-len", null);
            minlen = this.getAttributeAsLong(constraints, "min-len", minlen);
            Long maxlen = this.getAttributeAsLong(conf, "max-len", null);
            maxlen = this.getAttributeAsLong(constraints, "max-len", maxlen);
            if (!"".equals(eq)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("String parameter " + name + " should be equal to " + eq);
                }
                if (!value.equals(eq)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("and it is not");
                    }
                    return new ValidatorActionHelper(value, ValidatorActionResult.NOMATCH);
                }
            }
            if (!"".equals(eqp)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("String parameter " + name + " should be equal to " + params.get(eqp));
                }
                if (!value.equals(params.get(eqp))) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("and it is not");
                    }
                    return new ValidatorActionHelper(value, ValidatorActionResult.NOMATCH);
                }
            }
            if (minlen != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("String parameter " + name + " should be at least " + minlen + " characters long");
                }
                if ((long)value.length() < minlen) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("and it is shorter (" + value.length() + ")");
                    }
                    return new ValidatorActionHelper(value, ValidatorActionResult.TOOSMALL);
                }
            }
            if (maxlen != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("String parameter " + name + " should be at most " + maxlen + " characters long");
                }
                if ((long)value.length() > maxlen) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("and it is longer (" + value.length() + ")");
                    }
                    return new ValidatorActionHelper(value, ValidatorActionResult.TOOLARGE);
                }
            }
            if (!"".equals(regex)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("String parameter " + name + " should match regexp \"" + regex + "\"");
                }
                try {
                    RE r = new RE(regex);
                    if (!r.match(value)) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("and it does not match");
                        }
                        return new ValidatorActionHelper(value, ValidatorActionResult.NOMATCH);
                    }
                }
                catch (RESyntaxException rese) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().error("String parameter " + name + " regex error ", (Throwable)rese);
                    }
                    return new ValidatorActionHelper(value, ValidatorActionResult.NOMATCH);
                }
            }
            if (!"".equals(oneOf)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("String parameter " + name + " should be one of \"" + oneOf + "\"");
                }
                if (!oneOf.startsWith("|")) {
                    oneOf = "|" + oneOf;
                }
                if (!oneOf.endsWith("|")) {
                    oneOf = oneOf + "|";
                }
                if (value.indexOf("|") != -1) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("String parameter " + name + "contains \"|\" - can't validate that.");
                    }
                    return new ValidatorActionHelper(value, ValidatorActionResult.ERROR);
                }
                if (oneOf.indexOf("|" + value + "|") == -1) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("and it is not");
                    }
                    return new ValidatorActionHelper(value, ValidatorActionResult.NOMATCH);
                }
                return new ValidatorActionHelper(value, ValidatorActionResult.OK);
            }
        }
        return new ValidatorActionHelper(value);
    }

    private ValidatorActionHelper validateLong(String name, Configuration constraints, Configuration conf, Map params, boolean is_string, Object param) {
        boolean nullable = this.getNullable(conf, constraints);
        Long value = null;
        Long dflt = this.getLongValue(this.getDefault(conf, constraints), true);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Validating long parameter " + name + " (encoded in a string: " + is_string + ")");
        }
        try {
            value = this.getLongValue(param, is_string);
        }
        catch (Exception e) {
            return new ValidatorActionHelper(value, ValidatorActionResult.ERROR);
        }
        if (value == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Long parameter " + name + " is null");
            }
            if (!nullable) {
                return new ValidatorActionHelper(value, ValidatorActionResult.ISNULL);
            }
            return new ValidatorActionHelper(dflt);
        }
        if (constraints != null) {
            Long eq = this.getAttributeAsLong(constraints, "equals-to", null);
            String eqp = constraints.getAttribute("equals-to-param", "");
            Long min = this.getAttributeAsLong(conf, "min", null);
            min = this.getAttributeAsLong(constraints, "min", min);
            Long max = this.getAttributeAsLong(conf, "max", null);
            max = this.getAttributeAsLong(constraints, "max", max);
            if (eq != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Long parameter " + name + " should be equal to " + eq);
                }
                if (!value.equals(eq)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("and it is not");
                    }
                    return new ValidatorActionHelper(value, ValidatorActionResult.NOMATCH);
                }
            }
            if (!"".equals(eqp)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Long parameter " + name + " should be equal to " + params.get(eqp));
                }
                try {
                    Long _eqp = new Long(Long.parseLong((String)params.get(eqp)));
                    if (!value.equals(_eqp)) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("and it is not");
                        }
                        return new ValidatorActionHelper(value, ValidatorActionResult.NOMATCH);
                    }
                }
                catch (NumberFormatException nfe) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Long parameter " + name + ": " + eqp + " is no long", (Throwable)nfe);
                    }
                    return new ValidatorActionHelper(value, ValidatorActionResult.NOMATCH);
                }
            }
            if (min != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Long parameter " + name + " should be at least " + min);
                }
                if (min.compareTo(value) > 0) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("and it is not");
                    }
                    return new ValidatorActionHelper(value, ValidatorActionResult.TOOSMALL);
                }
            }
            if (max != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Long parameter " + name + " should be at most " + max);
                }
                if (max.compareTo(value) < 0) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("and it is not");
                    }
                    return new ValidatorActionHelper(value, ValidatorActionResult.TOOLARGE);
                }
            }
        }
        return new ValidatorActionHelper(value);
    }

    private ValidatorActionHelper validateDouble(String name, Configuration constraints, Configuration conf, Map params, boolean is_string, Object param) {
        boolean nullable = this.getNullable(conf, constraints);
        Double value = null;
        Double dflt = this.getDoubleValue(this.getDefault(conf, constraints), true);
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Validating double parameter " + name + " (encoded in a string: " + is_string + ")");
        }
        try {
            value = this.getDoubleValue(param, is_string);
        }
        catch (Exception e) {
            return new ValidatorActionHelper(value, ValidatorActionResult.ERROR);
        }
        if (value == null) {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("double parameter " + name + " is null");
            }
            if (!nullable) {
                return new ValidatorActionHelper(value, ValidatorActionResult.ISNULL);
            }
            return new ValidatorActionHelper(dflt);
        }
        if (constraints != null) {
            Double eq = this.getAttributeAsDouble(constraints, "equals-to", null);
            String eqp = constraints.getAttribute("equals-to-param", "");
            Double min = this.getAttributeAsDouble(conf, "min", null);
            min = this.getAttributeAsDouble(constraints, "min", min);
            Double max = this.getAttributeAsDouble(conf, "max", null);
            max = this.getAttributeAsDouble(constraints, "max", max);
            if (eq != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Double parameter " + name + " should be equal to " + eq);
                }
                if (!value.equals(eq)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("and it is not");
                    }
                    return new ValidatorActionHelper(value, ValidatorActionResult.NOMATCH);
                }
            }
            if (!"".equals(eqp)) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Double parameter " + name + " should be equal to " + params.get(eqp));
                }
                try {
                    Double _eqp = new Double(Double.parseDouble((String)params.get(eqp)));
                    if (!value.equals(_eqp)) {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("and it is not");
                        }
                        return new ValidatorActionHelper(value, ValidatorActionResult.NOMATCH);
                    }
                }
                catch (NumberFormatException nfe) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Double parameter " + name + ": " + eqp + " is no double", (Throwable)nfe);
                    }
                    return new ValidatorActionHelper(value, ValidatorActionResult.NOMATCH);
                }
            }
            if (min != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Double parameter " + name + " should be at least " + min);
                }
                if (0 > value.compareTo(min)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("and it is not");
                    }
                    return new ValidatorActionHelper(value, ValidatorActionResult.TOOSMALL);
                }
            }
            if (max != null) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Double parameter " + name + " should be at most " + max);
                }
                if (0 < value.compareTo(max)) {
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("and it is not");
                    }
                    return new ValidatorActionHelper(value, ValidatorActionResult.TOOLARGE);
                }
            }
        }
        return new ValidatorActionHelper(value);
    }

    private Double getDoubleValue(Object param, boolean is_string) throws ClassCastException, NumberFormatException {
        if (is_string) {
            String tmp = this.getStringValue(param);
            if (tmp == null) {
                return null;
            }
            return new Double(tmp);
        }
        return (Double)param;
    }

    private Long getLongValue(Object param, boolean is_string) throws ClassCastException, NumberFormatException {
        if (is_string) {
            String tmp = this.getStringValue(param);
            if (tmp == null) {
                return null;
            }
            return Long.decode(tmp);
        }
        return (Long)param;
    }

    private String getStringValue(Object param) throws ClassCastException {
        String value = (String)param;
        if (value != null && "".equals(value.trim())) {
            value = null;
        }
        return value;
    }

    private boolean getNullable(Configuration conf, Configuration cons) {
        try {
            String tmp = cons.getAttribute("nullable");
            return BooleanUtils.toBoolean((String)tmp);
        }
        catch (Exception e) {
            String tmp = "no";
            if (conf != null) {
                tmp = conf.getAttribute("nullable", "no");
            }
            return BooleanUtils.toBoolean((String)tmp);
        }
    }

    private String getDefault(Configuration conf, Configuration cons) {
        String dflt;
        block3: {
            dflt = "";
            try {
                dflt = cons.getAttribute("default");
            }
            catch (Exception e) {
                if (conf == null) break block3;
                dflt = conf.getAttribute("default", "");
            }
        }
        if ("".equals(dflt.trim())) {
            dflt = null;
        }
        return dflt;
    }

    private Long getAttributeAsLong(Configuration conf, String name, Long dflt) throws NumberFormatException {
        try {
            return new Long(conf.getAttribute(name));
        }
        catch (ConfigurationException e) {
            return dflt;
        }
    }

    private Double getAttributeAsDouble(Configuration conf, String name, Double dflt) throws NumberFormatException {
        try {
            return new Double(conf.getAttribute(name));
        }
        catch (ConfigurationException e) {
            return dflt;
        }
    }

    protected Map indexConfiguration(Configuration[] descriptor) {
        if (descriptor == null) {
            return new HashMap();
        }
        HashMap<String, Configuration> result = new HashMap<String, Configuration>(descriptor.length > 0 ? descriptor.length * 2 : 5);
        for (int i = descriptor.length - 1; i >= 0; --i) {
            String name = descriptor[i].getAttribute("name", "");
            result.put(name, descriptor[i]);
        }
        return result;
    }

    protected Collection resolveConstraints(String valsetstr, Map consets) {
        int j;
        Vector<Configuration> rules = new Vector<Configuration>();
        Configuration[] set = ((Configuration)consets.get(valsetstr)).getChildren("validate");
        for (j = 0; j < set.length; ++j) {
            rules.add(set[j]);
        }
        set = ((Configuration)consets.get(valsetstr)).getChildren("include");
        for (j = 0; j < set.length; ++j) {
            Collection tmp = this.resolveConstraints(set[j].getAttribute("name", ""), consets);
            rules.addAll(tmp);
        }
        return rules;
    }

    protected boolean isDescriptorReloadable() {
        boolean reloadable = true;
        if (this.settings.containsKey("reloadable")) {
            reloadable = Boolean.valueOf((String)this.settings.get("reloadable"));
        }
        return reloadable;
    }

    protected Collection getSetOfParameterNamesFromSitemap(String valstr, Map desc) {
        String[] rparams = null;
        Set<Object> set = new HashSet(20);
        if (!"*".equals(valstr.trim())) {
            rparams = StringUtils.split((String)valstr, (String)",");
            if (rparams != null) {
                for (int i = rparams.length - 1; i >= 0; --i) {
                    set.add(desc.get(rparams[i]));
                }
            }
        } else {
            set = desc.entrySet();
        }
        return set;
    }

    protected boolean validateSetOfParameters(Map desc, Map actionMap, Map resultMap, Collection set, Map params, boolean isString) {
        boolean allOK = true;
        String rule = null;
        Iterator i = set.iterator();
        while (i.hasNext()) {
            Configuration constr = (Configuration)i.next();
            String name = constr.getAttribute("name", null);
            ValidatorActionHelper result = this.validateParameter(name, rule = constr.getAttribute("rule", name), constr, desc, params, isString);
            if (!result.isOK()) {
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Validation failed for parameter " + name);
                }
                allOK = false;
            }
            actionMap.put(name, result.getObject());
            resultMap.put(name, result.getResult());
        }
        return allOK;
    }

    protected Map setResult(Map objectModel, Map actionMap, Map resultMap, boolean allOK) {
        if (!allOK) {
            actionMap = null;
            resultMap.put("*", ValidatorActionResult.ERROR);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("All form params validated. An error occurred.");
            }
        } else {
            resultMap.put("*", ValidatorActionResult.OK);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("All form params successfully validated");
            }
        }
        ObjectModelHelper.getRequest(objectModel).setAttribute("org.apache.cocoon.acting.FormValidatorAction.results", resultMap);
        return actionMap;
    }

    protected Configuration getDescriptor(SourceResolver resolver, Map objectModel, Parameters parameters) {
        Configuration conf;
        block2: {
            conf = null;
            try {
                conf = this.getConfiguration(parameters.getParameter("descriptor", (String)this.settings.get("descriptor")), resolver, parameters.getParameterAsBoolean("reloadable", this.isDescriptorReloadable()));
            }
            catch (ConfigurationException e) {
                if (!this.getLogger().isWarnEnabled()) break block2;
                this.getLogger().warn("Exception reading descriptor: ", (Throwable)e);
            }
        }
        return conf;
    }
}

