/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.portal.event.aspect.impl;

import java.util.Map;
import java.util.StringTokenizer;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.portal.PortalService;
import org.apache.cocoon.portal.event.Event;
import org.apache.cocoon.portal.event.Publisher;
import org.apache.cocoon.portal.event.aspect.EventAspect;
import org.apache.cocoon.portal.event.aspect.EventAspectContext;
import org.apache.cocoon.portal.layout.Layout;

public abstract class AbstractContentEventAspect
extends AbstractLogEnabled
implements EventAspect,
ThreadSafe,
Serviceable {
    protected ServiceManager manager;

    public void service(ServiceManager manager) throws ServiceException {
        this.manager = manager;
    }

    protected abstract String getRequestParameterName();

    protected abstract int getRequiredValueCount();

    protected abstract void publish(Publisher var1, Layout var2, String[] var3);

    protected void publish(PortalService service, Publisher publisher, String[] values) {
        Layout layout = service.getComponentManager().getProfileManager().getPortalLayout(values[0], values[1]);
        if (layout != null) {
            this.publish(publisher, layout, values);
        }
    }

    public void process(EventAspectContext context, PortalService service) {
        Request request = ObjectModelHelper.getRequest((Map)context.getObjectModel());
        String[] values = request.getParameterValues(this.getRequestParameterName());
        if (values != null) {
            Publisher publisher = context.getEventPublisher();
            int i = 0;
            while (i < values.length) {
                String value = values[i];
                Event e = null;
                try {
                    e = context.getEventConverter().decode(value);
                    if (null != e) {
                        publisher.publish(e);
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                if (e == null) {
                    StringTokenizer tokenizer = new StringTokenizer(value, "|");
                    int tokenNumber = 0;
                    int tokenCount = tokenizer.countTokens();
                    if (tokenCount == this.getRequiredValueCount() - 1) {
                        ++tokenNumber;
                        ++tokenCount;
                    }
                    if (tokenCount == this.getRequiredValueCount()) {
                        String[] eventValues = new String[tokenCount];
                        while (tokenizer.hasMoreTokens()) {
                            eventValues[tokenNumber] = tokenizer.nextToken();
                            ++tokenNumber;
                        }
                        this.publish(service, publisher, eventValues);
                    } else {
                        this.getLogger().warn("Data for Event is not set correctly");
                    }
                }
                ++i;
            }
        }
        context.invokeNext(service);
    }
}

