/*
 * Decompiled with CFR 0.152.
 */
package net.sf.pizzacompiler.compiler;

import net.sf.pizzacompiler.compiler.Constants;
import net.sf.pizzacompiler.compiler.Name;
import net.sf.pizzacompiler.compiler.Symbol;

public class Scope
implements Constants {
    Scope next;
    Symbol owner;
    Symbol[] hashtable;
    Symbol elems;
    static final int HASH_SIZE = 128;
    static final int HASH_MASK = 127;
    static Scope emptyScope = new Scope(null, null, null);
    static Scope errScope = new Scope(null, null);

    Scope(Scope scope, Symbol symbol, Symbol[] symbolArray) {
        this.next = scope;
        this.owner = symbol;
        this.hashtable = symbolArray;
        this.elems = null;
    }

    Scope(Scope scope, Symbol symbol) {
        this(scope, symbol, new Symbol[128]);
        if (scope == null) {
            for (int i = 0; i < 128; ++i) {
                this.hashtable[i] = Symbol.sentinel;
            }
        } else {
            for (int i = 0; i < 128; ++i) {
                this.hashtable[i] = scope.hashtable[i];
            }
        }
    }

    Scope dup() {
        return new Scope(this, this.owner, this.hashtable);
    }

    Scope leave() {
        while (this.elems != null) {
            int n = this.elems.name.index & 0x7F;
            this.hashtable[n] = this.hashtable[n].shadowed;
            this.elems = this.elems.sibling;
        }
        return this.next;
    }

    void enter(Symbol symbol) {
        int n = symbol.name.index & 0x7F;
        Symbol symbol2 = symbol.scope == null ? symbol : symbol.proxy(symbol.name);
        symbol2.scope = this;
        symbol2.shadowed = this.hashtable[n];
        this.hashtable[n] = symbol2;
        symbol2.sibling = this.elems;
        this.elems = symbol2;
        if (symbol2.owner == null) {
            symbol2.owner = this.owner;
        }
    }

    void enterIfAbsent(Symbol symbol) {
        Symbol symbol2 = this.lookup(symbol.name);
        while (symbol2.scope == this && symbol2.sym.kind != symbol.sym.kind) {
            symbol2 = symbol2.next();
        }
        if (symbol2.scope != this) {
            this.enter(symbol);
        }
    }

    void remove(Symbol symbol) {
        int n = symbol.name.index & 0x7F;
        Symbol symbol2 = this.hashtable[n];
        if (symbol2.sym == symbol) {
            this.hashtable[n] = symbol2.shadowed;
        } else {
            while (symbol2.shadowed != null && symbol2.shadowed.sym != symbol) {
                symbol2 = symbol2.shadowed;
            }
            if (symbol2.shadowed != null) {
                symbol2.shadowed = symbol2.shadowed.shadowed;
            }
        }
        symbol2 = this.elems;
        if (symbol2.sym == symbol) {
            this.elems = symbol2.sibling;
        } else {
            while (symbol2.sibling != null && symbol2.sibling.sym != symbol) {
                symbol2 = symbol2.sibling;
            }
            if (symbol2.sibling != null) {
                symbol2.sibling = symbol2.sibling.sibling;
            }
        }
    }

    void baseOn(Scope scope) {
        for (int i = 0; scope != null && i < 128; ++i) {
            Symbol symbol = this.hashtable[i];
            if (symbol.scope == null) {
                this.hashtable[i] = scope.hashtable[i];
                continue;
            }
            while (symbol.shadowed.scope != null) {
                symbol = symbol.shadowed;
            }
            symbol.shadowed = scope.hashtable[i];
        }
        this.next = scope;
    }

    Symbol lookup(Name name) {
        Symbol symbol = this.hashtable[name.index & 0x7F];
        while (symbol.scope != null && symbol.name != name) {
            symbol = symbol.shadowed;
        }
        if (symbol.scope == null && this == errScope) {
            return Symbol.errSymbol;
        }
        return symbol;
    }
}

