/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.chaperon.model.pattern;

import net.sourceforge.chaperon.common.Decoder;
import net.sourceforge.chaperon.model.Violations;
import net.sourceforge.chaperon.model.pattern.Pattern;

public class CharacterString
extends Pattern {
    private String string = "";

    public CharacterString() {
    }

    public CharacterString(String string) {
        this.setString(string);
    }

    public void setString(String string) {
        this.string = string;
    }

    public void setStringAsCode(String code) {
        this.setString(String.valueOf((char)Integer.parseInt(code)));
    }

    public String getString() {
        return this.string;
    }

    public String getStringAsCode() {
        if (this.string != null && this.string.length() == 1) {
            return String.valueOf((int)this.string.charAt(0));
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(Decoder.decode(this.string, "+*?^$() "));
        if (this.getMinOccurs() != 1 || this.getMaxOccurs() != 1) {
            if (this.getMinOccurs() == 0 && this.getMaxOccurs() == 1) {
                buffer.append("?");
            } else if (this.getMinOccurs() == 0 && this.getMaxOccurs() == Integer.MAX_VALUE) {
                buffer.append("*");
            } else if (this.getMinOccurs() == 1 && this.getMaxOccurs() == Integer.MAX_VALUE) {
                buffer.append("+");
            } else {
                buffer.append("{");
                buffer.append(String.valueOf(this.getMinOccurs()));
                buffer.append(",");
                buffer.append(String.valueOf(this.getMaxOccurs()));
                buffer.append("}");
            }
        }
        return buffer.toString();
    }

    public Object clone() {
        CharacterString clone = new CharacterString();
        clone.setMinOccurs(this.getMinOccurs());
        clone.setMaxOccurs(this.getMaxOccurs());
        clone.setString(this.getString());
        return clone;
    }

    public Violations validate() {
        Violations violations = new Violations();
        if (this.string == null || this.string.length() <= 0) {
            violations.addViolation("Character string contains no characters", this.getLocation());
        }
        return violations;
    }
}

