/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.acting;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.datasource.DataSourceComponent;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.parameters.Parameters;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.ProcessingException;
import org.apache.cocoon.acting.AbstractAction;
import org.apache.cocoon.acting.AbstractDatabaseAction;
import org.apache.cocoon.environment.ObjectModelHelper;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.environment.Request;
import org.apache.cocoon.environment.SourceResolver;

public final class DatabaseDeleteAction
extends AbstractDatabaseAction
implements ThreadSafe {
    private static final Map deleteStatements = new HashMap();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Map act(Redirector redirector, SourceResolver resolver, Map objectModel, String source, Parameters param) throws Exception {
        Connection conn;
        DataSourceComponent datasource;
        block16: {
            Map map;
            block17: {
                datasource = null;
                conn = null;
                int currentIndex = 0;
                boolean reloadable = true;
                if (this.settings.containsKey((Object)"reloadable")) {
                    reloadable = Boolean.valueOf((String)this.settings.get((Object)"reloadable"));
                }
                try {
                    Configuration conf = this.getConfiguration(param.getParameter("descriptor", (String)this.settings.get((Object)"descriptor")), resolver, param.getParameterAsBoolean("reloadable", reloadable));
                    String query = this.getDeleteQuery(conf);
                    datasource = this.getDataSource(conf);
                    conn = datasource.getConnection();
                    Request request = ObjectModelHelper.getRequest((Map)objectModel);
                    if (conn.getAutoCommit()) {
                        conn.setAutoCommit(false);
                    }
                    PreparedStatement statement = conn.prepareStatement(query);
                    Configuration[] keys = conf.getChild("table").getChild("keys").getChildren("key");
                    int i = 0;
                    while (true) {
                        if (i >= keys.length) {
                            int rows = statement.executeUpdate();
                            conn.commit();
                            statement.close();
                            if (rows <= 0) break block16;
                            request.setAttribute("rows", (Object)Integer.toString(rows));
                            map = AbstractAction.EMPTY_MAP;
                            if (conn == null) break block17;
                            break;
                        }
                        this.setColumn(statement, i + 1, request, keys[i]);
                        ++i;
                    }
                }
                catch (Exception e) {
                    try {
                        if (conn == null) throw new ProcessingException("Could not delete record :position = " + currentIndex, (Throwable)e);
                        conn.rollback();
                        throw new ProcessingException("Could not delete record :position = " + currentIndex, (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (conn != null) {
                            try {
                                conn.close();
                            }
                            catch (SQLException sqe) {
                                this.getLogger().warn("There was an error closing the datasource", (Throwable)sqe);
                            }
                        }
                        if (datasource == null) throw throwable;
                        this.dbselector.release(datasource);
                        throw throwable;
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException sqe) {
                    this.getLogger().warn("There was an error closing the datasource", (Throwable)sqe);
                }
            }
            if (datasource == null) return map;
            this.dbselector.release((Object)datasource);
            return map;
        }
        if (conn != null) {
            try {
                conn.close();
            }
            catch (SQLException sqe) {
                this.getLogger().warn("There was an error closing the datasource", (Throwable)sqe);
            }
        }
        if (datasource == null) return null;
        this.dbselector.release((Object)datasource);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getDeleteQuery(Configuration conf) throws ConfigurationException {
        String query = null;
        Map map = deleteStatements;
        synchronized (map) {
            query = (String)deleteStatements.get(conf);
            if (query == null) {
                Configuration table = conf.getChild("table");
                Configuration[] keys = table.getChild("keys").getChildren("key");
                StringBuffer queryBuffer = new StringBuffer("DELETE FROM ");
                queryBuffer.append(table.getAttribute("name"));
                queryBuffer.append(" WHERE ");
                queryBuffer.append(this.buildList(keys, " AND "));
                query = queryBuffer.toString();
                deleteStatements.put(conf, query);
            }
        }
        return query;
    }
}

