/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import org.mortbay.util.Log;

public class LogWriter
extends Writer {
    private CharArrayWriter buf = new CharArrayWriter();
    private static final String lineEnd = System.getProperty("line.separator");

    public LogWriter() {
        this.lock = this.buf;
    }

    public void write(int c) throws IOException {
        this.buf.write(c);
    }

    public void write(char[] cbuf) throws IOException {
        this.buf.write(cbuf, 0, cbuf.length);
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        this.buf.write(cbuf, off, len);
    }

    public void write(String str) throws IOException {
        this.buf.write(str, 0, str.length());
    }

    public void write(String str, int off, int len) throws IOException {
        this.buf.write(str, off, len);
    }

    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String line = this.buf.toString();
            if (line.endsWith(lineEnd)) {
                line = line.substring(0, line.length() - lineEnd.length());
            }
            Log.event(line);
            this.buf.reset();
        }
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flush();
            this.buf = null;
        }
    }
}

