/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.datatype.convertor;

import java.text.ParseException;
import java.util.Date;
import java.util.Locale;
import org.apache.cocoon.forms.datatype.convertor.ConversionResult;
import org.apache.cocoon.forms.datatype.convertor.Convertor;
import org.apache.cocoon.forms.datatype.convertor.LocaleMap;
import org.apache.cocoon.xml.AttributesImpl;
import org.outerj.i18n.DateFormat;
import org.outerj.i18n.I18nSupport;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class FormattingDateConvertor
implements Convertor {
    private int style = 3;
    private int variant = 1;
    private LocaleMap localizedPatterns = new LocaleMap();
    private String nonLocalizedPattern;
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int DATE_TIME = 3;
    private static final String CONVERTOR_EL = "convertor";
    static /* synthetic */ Class class$java$util$Date;

    public ConversionResult convertFromString(String value, Locale locale, Convertor.FormatCache formatCache) {
        DateFormat dateFormat = this.getDateFormat(locale, formatCache);
        try {
            return new ConversionResult(dateFormat.parse(value));
        }
        catch (ParseException e) {
            return ConversionResult.create("date");
        }
    }

    public String convertToString(Object value, Locale locale, Convertor.FormatCache formatCache) {
        DateFormat dateFormat = this.getDateFormat(locale, formatCache);
        return dateFormat.format((Date)value);
    }

    private final DateFormat getDateFormat(Locale locale, Convertor.FormatCache formatCache) {
        DateFormat dateFormat = null;
        if (formatCache != null) {
            dateFormat = (DateFormat)formatCache.get();
        }
        if (dateFormat == null) {
            dateFormat = this.getDateFormat(locale);
            if (formatCache != null) {
                formatCache.store(dateFormat);
            }
        }
        return dateFormat;
    }

    protected DateFormat getDateFormat(Locale locale) {
        DateFormat dateFormat = null;
        switch (this.variant) {
            case 1: {
                dateFormat = I18nSupport.getInstance().getDateFormat(this.style, locale);
                break;
            }
            case 2: {
                dateFormat = I18nSupport.getInstance().getTimeFormat(this.style, locale);
                break;
            }
            case 3: {
                dateFormat = I18nSupport.getInstance().getDateTimeFormat(this.style, this.style, locale);
            }
        }
        String pattern = (String)this.localizedPatterns.get(locale);
        if (pattern != null) {
            dateFormat.applyLocalizedPattern(pattern);
        } else if (this.nonLocalizedPattern != null) {
            dateFormat.applyPattern(this.nonLocalizedPattern);
        }
        return dateFormat;
    }

    public Class getTypeClass() {
        return class$java$util$Date == null ? (class$java$util$Date = FormattingDateConvertor.class$("java.util.Date")) : class$java$util$Date;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public void setVariant(int variant) {
        if (variant != 1 && variant != 2 && variant != 3) {
            throw new IllegalArgumentException("Invalid value for variant parameter.");
        }
        this.variant = variant;
    }

    public void addFormattingPattern(Locale locale, String pattern) {
        this.localizedPatterns.put(locale, pattern);
    }

    public void setNonLocalizedPattern(String pattern) {
        this.nonLocalizedPattern = pattern;
    }

    public void generateSaxFragment(ContentHandler contentHandler, Locale locale) throws SAXException {
        String pattern = (String)this.localizedPatterns.get(locale);
        if (pattern == null) {
            pattern = this.nonLocalizedPattern;
        }
        if (pattern != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addCDATAAttribute("pattern", pattern);
            contentHandler.startElement("http://apache.org/cocoon/forms/1.0#instance", CONVERTOR_EL, "fi:convertor", (Attributes)attrs);
            contentHandler.endElement("http://apache.org/cocoon/forms/1.0#instance", CONVERTOR_EL, "fi:convertor");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

