/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.forms.binding;

import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.service.ServiceException;
import org.apache.avalon.framework.service.ServiceManager;
import org.apache.avalon.framework.service.Serviceable;
import org.apache.avalon.framework.thread.ThreadSafe;
import org.apache.cocoon.forms.CacheManager;
import org.apache.cocoon.forms.binding.Binding;
import org.apache.cocoon.forms.binding.BindingException;
import org.apache.cocoon.forms.binding.BindingManager;
import org.apache.cocoon.forms.binding.JXPathBindingBase;
import org.apache.cocoon.forms.binding.JXPathBindingBuilderBase;
import org.apache.cocoon.forms.datatype.DatatypeManager;
import org.apache.cocoon.forms.util.DomHelper;
import org.apache.cocoon.forms.util.SimpleServiceSelector;
import org.apache.excalibur.source.Source;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class JXPathBindingManager
extends AbstractLogEnabled
implements BindingManager,
Serviceable,
Disposable,
Initializable,
Configurable,
ThreadSafe {
    private static final String PREFIX = "CocoonFormBinding:";
    private ServiceManager serviceManager;
    private DatatypeManager datatypeManager;
    private Configuration configuration;
    private SimpleServiceSelector bindingBuilderSelector;
    private CacheManager cacheManager;
    static /* synthetic */ Class class$org$apache$cocoon$forms$binding$JXPathBindingBuilderBase;

    public void service(ServiceManager serviceManager) throws ServiceException {
        this.serviceManager = serviceManager;
        this.datatypeManager = (DatatypeManager)serviceManager.lookup(DatatypeManager.ROLE);
        this.cacheManager = (CacheManager)serviceManager.lookup(CacheManager.ROLE);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.configuration = configuration;
    }

    public void initialize() throws Exception {
        this.bindingBuilderSelector = new SimpleServiceSelector("binding", class$org$apache$cocoon$forms$binding$JXPathBindingBuilderBase == null ? (class$org$apache$cocoon$forms$binding$JXPathBindingBuilderBase = JXPathBindingManager.class$("org.apache.cocoon.forms.binding.JXPathBindingBuilderBase")) : class$org$apache$cocoon$forms$binding$JXPathBindingBuilderBase);
        this.bindingBuilderSelector.enableLogging(this.getLogger());
        this.bindingBuilderSelector.configure(this.configuration.getChild("bindings"));
    }

    public Binding createBinding(Source source) throws BindingException {
        Binding binding = (Binding)this.cacheManager.get(source, PREFIX);
        if (binding == null) {
            try {
                InputSource is = new InputSource(source.getInputStream());
                is.setSystemId(source.getURI());
                Document doc = DomHelper.parse(is);
                Element rootElm = doc.getDocumentElement();
                if ("http://apache.org/cocoon/forms/1.0#binding".equals(rootElm.getNamespaceURI())) {
                    binding = this.getBuilderAssistant().getBindingForConfigurationElement(rootElm);
                    ((JXPathBindingBase)binding).enableLogging(this.getLogger());
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Creation of new Binding finished. " + binding);
                    }
                } else if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Root Element of said binding file is in wrong namespace.");
                }
                this.cacheManager.set(binding, source, PREFIX);
            }
            catch (BindingException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BindingException("Error creating binding from " + source.getURI(), e);
            }
        }
        return binding;
    }

    private Assistant getBuilderAssistant() {
        return new Assistant();
    }

    public void dispose() {
        this.bindingBuilderSelector.dispose();
        this.bindingBuilderSelector = null;
        this.serviceManager.release((Object)this.datatypeManager);
        this.datatypeManager = null;
        this.cacheManager = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class Assistant {
        private JXPathBindingBuilderBase getBindingBuilder(String bindingType) throws BindingException {
            try {
                return (JXPathBindingBuilderBase)JXPathBindingManager.this.bindingBuilderSelector.select(bindingType);
            }
            catch (ServiceException e) {
                throw new BindingException("Cannot handle binding element with name \"" + bindingType + "\".", (Exception)((Object)e));
            }
        }

        public JXPathBindingBase getBindingForConfigurationElement(Element configElm) throws BindingException {
            String bindingType = configElm.getLocalName();
            JXPathBindingBuilderBase bindingBuilder = this.getBindingBuilder(bindingType);
            JXPathBindingBase childBinding = bindingBuilder.buildBinding(configElm, this);
            return childBinding;
        }

        public JXPathBindingBase[] makeChildBindings(Element parentElement) throws BindingException {
            Element[] childElements;
            if (parentElement != null && (childElements = DomHelper.getChildElements(parentElement, "http://apache.org/cocoon/forms/1.0#binding")).length > 0) {
                JXPathBindingBase[] childBindings = new JXPathBindingBase[childElements.length];
                int i = 0;
                while (i < childElements.length) {
                    childBindings[i] = this.getBindingForConfigurationElement(childElements[i]);
                    ++i;
                }
                return childBindings;
            }
            return null;
        }

        public DatatypeManager getDatatypeManager() {
            return JXPathBindingManager.this.datatypeManager;
        }

        public ServiceManager getServiceManager() {
            return JXPathBindingManager.this.serviceManager;
        }
    }
}

