/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
/*
 * Created by Vim :-)
 * User: Pierre Dittgen
 * Date: 2 apr. 2004
 */
package fr.gouv.culture.sdx.search.lucene.analysis.tokenizer;

// Jdk import
import java.io.Reader;

/**
 * Title: LaxistLowerCaseTokenizer
 * Description: Like org.apache.lucene.analysis.LowerCaseTokenizer but
 * inherits from LetterOrDigitTokenizer, not from LetterTokenizer
 * Copyright:   Copyright (c) 2004
 * Company:
 * @author Pierre Dittgen
 * @version 1.0
 *
 */
public final class LaxistLowerCaseTokenizer extends LetterOrDigitTokenizer
{
	public LaxistLowerCaseTokenizer(Reader in)
	{
		super(in);
	}

	protected char normalize(char c)
	{
		return Character.toLowerCase(c);
	}
}

