/*
Copyright (C) 2000-2010  Ministere de la culture et de la communication (France), AJLSM
See LICENCE file
*/
package fr.gouv.culture.sdx.document;

import java.text.ParseException;

import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

import fr.gouv.culture.oai.OAIObject;
import fr.gouv.culture.oai.util.OAIUtilities;
import fr.gouv.culture.sdx.search.lucene.DateField;
import fr.gouv.culture.sdx.utils.Utilities;

/**
 * OAI document properties. Attach the haverst date and the OAI identifier of the document. 
 * @author mpichot
 */
public class OAIDocument extends XMLDocument implements OAIObject {

  private String dateString;
  private String identifier;
  public static final String INTERNAL_FIELD_NAME_SDXOAIDATE = "sdxoaidate";
  public static final String INTERNAL_FIELD_NAME_SDXOAIID = "sdxoaiid";


    public OAIDocument() {
        dateString = null;
        identifier = null;
    }

    /**
     * Attach system fields of the OAI document :
     * sdxoaidate : harvest date
     * sdxoaiid : OAI identifier 
     */
    public void addAdditionalSystemFields(Document doc) {
    	
    	//The date
    	if(Utilities.checkString(dateString)){
    		
    		java.util.Date myDate = null;
    		java.util.TimeZone gmtZone = java.util.TimeZone.getTimeZone("GMT");
    		
    		//Try seconds granularity "YYYY-DD-MMThh:mm:ssZ"
    		try{
    			java.text.SimpleDateFormat _sdf = new java.text.SimpleDateFormat(OAIObject.STRING_DATEFORMAT_GRANULARITY_SECOND);
    			_sdf.setTimeZone(gmtZone);
    			myDate = _sdf.parse(dateString);
    		} catch (ParseException e) {
    			
    			//Try day granularity "YYYY-DD-MM"
    			try{
    				java.text.SimpleDateFormat _sdf = new java.text.SimpleDateFormat(OAIObject.STRING_DATEFORMAT_GRANULARITY_DAY);
        			_sdf.setTimeZone(gmtZone);
    				myDate = _sdf.parse(dateString);
    			} catch (ParseException ee) {
    				ee.printStackTrace();
    			}
    			
    		}
    		
    		if(myDate!=null){
	    		long oaidate = myDate.getTime();
	    		//Field dateField = Field.Keyword(OAIDocument.INTERNAL_FIELD_NAME_SDXOAIDATE, DateField.timeToString(oaidate));
	    		Field dateField = new Field(OAIDocument.INTERNAL_FIELD_NAME_SDXOAIDATE, DateField.timeToString(oaidate), Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO);
	    		if(dateField != null) doc.add(dateField);
    		} else{
    			String message = "Impossible de parser la date " + dateString + " du document OAI " + identifier;
    			OAIUtilities.logError(_logger, message, null);
    		}
    	}
        
        //The identifier
        if(Utilities.checkString(identifier)){
        	// MAJ Lucene 2.1.0
            //Field idField = Field.Keyword(OAIDocument.INTERNAL_FIELD_NAME_SDXOAIID, identifier);
            Field idField = new Field(OAIDocument.INTERNAL_FIELD_NAME_SDXOAIID, identifier, Field.Store.YES/*tenter Field.Store.COMPRESS ?*/, Field.Index.UN_TOKENIZED, Field.TermVector.NO);
            if(idField != null) doc.add(idField);
        }
    }

    public String getDateString()
    {
        return dateString;
    }

    public void setDateString(String dateString)
    {
        this.dateString = dateString;
    }

    public String getIdentifier()
    {
        return identifier;
    }

    public void setIdentifier(String identifier)
    {
        this.identifier = identifier;
    }

}