/*
 * Decompiled with CFR 0.152.
 */
package com.nwalsh.saxon;

import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.tree.AttributeCollection;
import com.nwalsh.saxon.Callout;
import com.nwalsh.saxon.FormatCallout;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;

public class FormatDingbatCallout
extends FormatCallout {
    int graphicsMax = 0;

    public FormatDingbatCallout(NamePool nPool, int max, boolean fo) {
        super(nPool, fo);
        this.graphicsMax = max;
    }

    public void formatCallout(Emitter rtfEmitter, Callout callout) {
        Element area = callout.getArea();
        int num = callout.getCallout();
        String userLabel = this.areaLabel(area);
        String label = "";
        if (userLabel != null) {
            label = userLabel;
        }
        try {
            if (userLabel == null && num <= this.graphicsMax) {
                int inName = 0;
                AttributeCollection inAttr = null;
                int[] namespaces = new int[1];
                if (this.foStylesheet) {
                    inName = this.namePool.allocate("fo", "http://www.w3.org/1999/XSL/Format", "inline");
                    inAttr = new AttributeCollection(this.namePool);
                    inAttr.addAttribute("", "", "font-family", "CDATA", "ZapfDingbats");
                } else {
                    inName = this.namePool.allocate("", "", "font");
                    inAttr = new AttributeCollection(this.namePool);
                    inAttr.addAttribute("", "", "face", "CDATA", "ZapfDingbats");
                }
                this.startSpan(rtfEmitter);
                rtfEmitter.startElement(inName, (Attributes)inAttr, namespaces, 0);
                char[] chars = new char[]{(char)(10101 + num)};
                rtfEmitter.characters(chars, 0, 1);
                rtfEmitter.endElement(inName);
                this.endSpan(rtfEmitter);
            } else {
                this.formatTextCallout(rtfEmitter, callout);
            }
        }
        catch (TransformerException transformerException) {
            System.out.println("Transformer Exception in graphic formatCallout");
        }
    }
}

