/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cocoon.components.treeprocessor.sitemap;

import org.apache.cocoon.components.treeprocessor.AbstractProcessingNode;
import org.apache.cocoon.components.treeprocessor.InvokeContext;
import org.apache.cocoon.components.treeprocessor.variables.VariableResolver;
import org.apache.cocoon.environment.Environment;
import org.apache.cocoon.environment.PermanentRedirector;
import org.apache.cocoon.environment.Redirector;
import org.apache.cocoon.sitemap.PatternException;

public class RedirectToURINode
extends AbstractProcessingNode {
    private VariableResolver uri;
    private boolean createSession;
    private boolean global;
    private boolean permanent;

    public RedirectToURINode(VariableResolver uri, boolean createSession, boolean global, boolean permanent) throws PatternException {
        this.global = global;
        this.uri = uri;
        this.createSession = createSession;
        this.permanent = permanent;
    }

    public final boolean invoke(Environment env, InvokeContext context) throws Exception {
        String resolvedURI = this.uri.resolve(context, env.getObjectModel());
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Redirecting to '" + resolvedURI + "' at " + this.getLocation());
        }
        Redirector redirector = context.getRedirector();
        if (this.global) {
            redirector.globalRedirect(this.createSession, resolvedURI);
        } else if (this.permanent && redirector instanceof PermanentRedirector) {
            ((PermanentRedirector)((Object)redirector)).permanentRedirect(this.createSession, resolvedURI);
        } else {
            redirector.redirect(this.createSession, resolvedURI);
        }
        return true;
    }
}

